/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_15;

import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.plan.PlanDao;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.repository.PlanRepositoryLink;
import com.atlassian.bamboo.repository.PlanRepositoryLinkDao;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.utils.BambooIterators;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataBuilder;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataImpl;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfiguration;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfigurationXmlConverter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask51518ReEncryptPlanBranchRepositories
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask51518ReEncryptPlanBranchRepositories.class);
    private static final int PAGE_SIZE = 100;
    @VisibleForTesting
    static final Set<String> ENCRYPTED_KEYS = ImmutableSortedSet.of((Comparable)((Object)StringUtils.lowerCase((String)"repository.bitbucket.password", (Locale)Locale.ENGLISH)), (Comparable)((Object)StringUtils.lowerCase((String)"repository.bitbucket.sshKey", (Locale)Locale.ENGLISH)), (Comparable)((Object)StringUtils.lowerCase((String)"repository.bitbucket.sshPassphrase", (Locale)Locale.ENGLISH)), (Comparable)((Object)StringUtils.lowerCase((String)"repository.git.password", (Locale)Locale.ENGLISH)), (Comparable)((Object)StringUtils.lowerCase((String)"repository.git.ssh.key", (Locale)Locale.ENGLISH)), (Comparable)((Object)StringUtils.lowerCase((String)"repository.git.ssh.passphrase", (Locale)Locale.ENGLISH)), (Comparable[])new String[]{StringUtils.lowerCase((String)"repository.github.password", (Locale)Locale.ENGLISH), StringUtils.lowerCase((String)"repository.hg.password.password", (Locale)Locale.ENGLISH), StringUtils.lowerCase((String)"repository.hg.ssh_proxy.privateKey", (Locale)Locale.ENGLISH), StringUtils.lowerCase((String)"repository.hg.ssh_proxy.passphrase", (Locale)Locale.ENGLISH), StringUtils.lowerCase((String)"repository.hg.keyfile.privateKey", (Locale)Locale.ENGLISH), StringUtils.lowerCase((String)"repository.svn.userPassword", (Locale)Locale.ENGLISH), StringUtils.lowerCase((String)"repository.svn.passphrase", (Locale)Locale.ENGLISH), StringUtils.lowerCase((String)"repository.svn.sslPassphrase", (Locale)Locale.ENGLISH), StringUtils.lowerCase((String)"repository.cvs.password", (Locale)Locale.ENGLISH), StringUtils.lowerCase((String)"repository.cvs.passphrase", (Locale)Locale.ENGLISH), StringUtils.lowerCase((String)"repository.p4.password", (Locale)Locale.ENGLISH), StringUtils.lowerCase((String)"repository.stash.key.private", (Locale)Locale.ENGLISH)});
    @VisibleForTesting
    static final Set<String> VCS_BRANCH_KEYS = ImmutableSortedSet.of((Comparable)((Object)StringUtils.lowerCase((String)"repository.github.branch", (Locale)Locale.ENGLISH)), (Comparable)((Object)StringUtils.lowerCase((String)"repository.cvs.branchName", (Locale)Locale.ENGLISH)));
    @VisibleForTesting
    static final Set<String> LEGACY_KEYS_TO_IGNORE = ImmutableSortedSet.of((Comparable)((Object)StringUtils.lowerCase((String)ConfigUtils.BAMBOO_DELIMITER_PARSING_DISABLED, (Locale)Locale.ENGLISH)), (Comparable)((Object)StringUtils.lowerCase((String)"[@xml:space]", (Locale)Locale.ENGLISH)), (Comparable)((Object)StringUtils.lowerCase((String)"repository.common.quietPeriod.enabled", (Locale)Locale.ENGLISH)), (Comparable)((Object)StringUtils.lowerCase((String)"repository.common.quietPeriod.period", (Locale)Locale.ENGLISH)), (Comparable)((Object)StringUtils.lowerCase((String)"repository.common.quietPeriod.maxRetries", (Locale)Locale.ENGLISH)), (Comparable)((Object)StringUtils.lowerCase((String)"changeset.filter.pattern.regex", (Locale)Locale.ENGLISH)), (Comparable[])new String[]{StringUtils.lowerCase((String)"commit.isolation.option", (Locale)Locale.ENGLISH), StringUtils.lowerCase((String)"filter.pattern.option", (Locale)Locale.ENGLISH), StringUtils.lowerCase((String)"filter.pattern.regex", (Locale)Locale.ENGLISH)});
    @Autowired
    private BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate;
    @Autowired
    private PlanDao planDao;
    @Autowired
    private PlanRepositoryLinkDao planRepositoryLinkDao;
    @Autowired
    private RawRepositoryConfigurationXmlConverter rawRepositoryConfigurationXmlConverter;
    @Autowired
    private RepositoryDefinitionDao repositoryDefinitionDao;
    private long updatedRepositories;

    protected UpgradeTask51518ReEncryptPlanBranchRepositories() {
        super("Re-encrypting repositories for plan branches");
    }

    public void doUpgrade() throws Exception {
        long numberOfChainBranches = this.planDao.countAll(ChainBranch.class);
        int i = 0;
        while ((long)i < numberOfChainBranches) {
            int firstResult = i;
            this.bambooTransactionHibernateTemplate.doWork(connection -> this.planDao.findAllPlans(ChainBranch.class, firstResult, 100).forEach(this::upgradeChainBranch));
            i += 100;
        }
        log.info((Object)String.format("Updated a total of %d repositories", this.updatedRepositories));
    }

    private void upgradeChainBranch(ChainBranch chainBranch) {
        List branchRepositoryLinks = this.planRepositoryLinkDao.getPlanRepositoryLinks((ImmutablePlan)chainBranch);
        for (PlanRepositoryLink branchRepositoryLink : branchRepositoryLinks) {
            if (!this.upgradeChainBranchRepository(branchRepositoryLink.getRepositoryDataEntity())) continue;
            ++this.updatedRepositories;
        }
    }

    @VisibleForTesting
    boolean upgradeChainBranchRepository(RepositoryDataEntity branchRepo) {
        if (branchRepo.getParent() == null) {
            log.debug((Object)String.format("Skipping repository %s (%d) - no parent repository", branchRepo.getName(), branchRepo.getId()));
            return false;
        }
        RawRepositoryConfiguration branchRepoConfig = this.rawRepositoryConfigurationXmlConverter.fromEntity(branchRepo);
        if (branchRepoConfig.getLegacyXml() == null) {
            Map branchRepoServerConfig = branchRepoConfig.getServerConfiguration();
            if (MapUtils.isEmpty((Map)branchRepoServerConfig)) {
                log.debug((Object)String.format("Skipping repository %s (%d) - not overriding parent's configuration", branchRepo.getName(), branchRepo.getId()));
                return false;
            }
            Map<String, String> chainRepoServerConfig = this.getServerConfiguration(branchRepo.getParent());
            if (!this.configsEqualIgnoringSecretKeys(branchRepoServerConfig, chainRepoServerConfig)) {
                log.debug((Object)String.format("Skipping repository %s (%d) - server configurations have diverged", branchRepo.getName(), branchRepo.getId()));
                return false;
            }
            log.info((Object)String.format("Updating configuration for repository %s (%d)", branchRepo.getName(), branchRepo.getId()));
            PartialVcsRepositoryData partialBranchRepoData = PartialVcsRepositoryDataBuilder.newBuilder().fullCopy(this.toPartialRepositoryData(branchRepo)).serverConfiguration(null).build();
            branchRepo.setXmlData(this.rawRepositoryConfigurationXmlConverter.asXml(partialBranchRepoData));
        } else {
            XMLConfiguration chainRepoLegacyConfig;
            XMLConfiguration branchRepoLegacyConfig = ConfigUtils.getXmlConfigFromXmlString((String)branchRepoConfig.getLegacyXml());
            if (!this.legacyConfigsEqualIgnoringSecretAndBranchKeys(branchRepoLegacyConfig, chainRepoLegacyConfig = this.getLegacyXmlConfig(branchRepo.getParent()))) {
                log.debug((Object)String.format("Skipping repository %s (%d) - legacy configurations have diverged", branchRepo.getName(), branchRepo.getId()));
                return false;
            }
            log.info((Object)String.format("Updating configuration for legacy repository %s (%d)", branchRepo.getName(), branchRepo.getId()));
            this.copyLegacyConfigIgnoringBranchKeys(chainRepoLegacyConfig, branchRepoLegacyConfig);
            branchRepo.setXmlData(ConfigUtils.asXmlString((XMLConfiguration)branchRepoLegacyConfig));
        }
        this.repositoryDefinitionDao.save((BambooObject)branchRepo);
        return true;
    }

    @VisibleForTesting
    Map<String, String> getServerConfiguration(RepositoryDataEntity repository) {
        Map serverConfiguration = this.rawRepositoryConfigurationXmlConverter.fromEntity(repository).getServerConfiguration();
        return serverConfiguration != null ? serverConfiguration : (repository.getParent() != null ? this.getServerConfiguration(repository.getParent()) : Collections.emptyMap());
    }

    @VisibleForTesting
    XMLConfiguration getLegacyXmlConfig(RepositoryDataEntity repository) {
        String legacyXml = this.rawRepositoryConfigurationXmlConverter.fromEntity(repository).getLegacyXml();
        return legacyXml != null ? ConfigUtils.getXmlConfigFromXmlString((String)legacyXml) : (repository.getParent() != null ? this.getLegacyXmlConfig(repository.getParent()) : new XMLConfiguration());
    }

    private boolean configsEqualIgnoringSecretKeys(Map<String, String> serverConfig1, Map<String, String> serverConfig2) {
        return serverConfig1.size() == serverConfig2.size() && Objects.equals(Maps.filterKeys(serverConfig1, key -> !this.isSecretKey((String)key)), Maps.filterKeys(serverConfig2, key -> !this.isSecretKey((String)key)));
    }

    private boolean legacyConfigsEqualIgnoringSecretAndBranchKeys(XMLConfiguration legacyConfig1, XMLConfiguration legacyConfig2) {
        Predicate<String> relevantKeyPredicate = key -> !this.isIgnoredLegacyKey((String)key) && !this.isSecretKey((String)key) && !this.isVcsBranchKey((String)key);
        Set<String> config1Keys = this.getXmlConfigurationKeys(legacyConfig1, relevantKeyPredicate);
        Set<String> config2Keys = this.getXmlConfigurationKeys(legacyConfig2, relevantKeyPredicate);
        return config1Keys.size() == config2Keys.size() && config1Keys.stream().allMatch(key -> legacyConfig2.containsKey(key) && legacyConfig1.getProperty(key).equals(legacyConfig2.getProperty(key)));
    }

    private Set<String> getXmlConfigurationKeys(XMLConfiguration configuration, Predicate<String> keyPredicate) {
        return BambooIterators.stream((Iterator)configuration.getKeys()).filter(keyPredicate).collect(Collectors.toSet());
    }

    private void copyLegacyConfigIgnoringBranchKeys(XMLConfiguration fromConfig, XMLConfiguration toConfig) {
        BambooIterators.stream((Iterator)fromConfig.getKeys()).filter(key -> !this.isVcsBranchKey((String)key)).forEach(key -> toConfig.setProperty(key, fromConfig.getProperty(key)));
    }

    private PartialVcsRepositoryData toPartialRepositoryData(RepositoryDataEntity repository) {
        return new PartialVcsRepositoryDataImpl(repository, this.rawRepositoryConfigurationXmlConverter.fromEntity(repository), repository.getParent() != null ? this.toPartialRepositoryData(repository.getParent()).getCompleteData() : null);
    }

    private boolean isIgnoredLegacyKey(String configKey) {
        return LEGACY_KEYS_TO_IGNORE.contains(StringUtils.lowerCase((String)configKey, (Locale)Locale.ENGLISH));
    }

    private boolean isVcsBranchKey(String configKey) {
        return VCS_BRANCH_KEYS.contains(StringUtils.lowerCase((String)configKey, (Locale)Locale.ENGLISH));
    }

    private boolean isSecretKey(String configKey) {
        return ENCRYPTED_KEYS.contains(StringUtils.lowerCase((String)configKey, (Locale)Locale.ENGLISH));
    }
}

