/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_15;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.upgrade.tasks.util.ForeignKeyConstraintUtils;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.google.common.collect.HashMultimap;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask51509DropHibernate2FkConstraints
extends AbstractBootstrapUpgradeTask {
    private static final String[] TABLES = new String[]{"ACL_ENTRY", "ACL_OBJECT_IDENTITY", "AGENT_ASSIGNMENT", "AGENT_AUTHENTICATION", "ARTIFACT", "ARTIFACT_DEFINITION", "ARTIFACT_SUBSCRIPTION", "AUDIT_LOG", "AUTHOR", "AUTH_ATTEMPT_INFO", "BANDANA", "BRANCH_COMMIT_INFO", "BRS_ARTIFACT_LINK", "BRS_CONSUMED_SUBSCRIPTION", "BRS_LINKEDJIRAISSUES", "BUILD", "BUILDRESULTSUMMARY", "BUILDRESULTSUMMARY_CUSTOMDATA", "BUILDRESULTSUMMARY_LABEL", "BUILD_DEFINITION", "BUILD_NUMBERS", "CAPABILITY", "CAPABILITY_SET", "CHAIN_STAGE", "CHAIN_STAGE_RESULT", "COMMIT_FILES", "CREDENTIALS", "DEPLOYMENT_ENVIRONMENT", "DEPLOYMENT_ENV_VCS_LOCATION", "DEPLOYMENT_PROJECT", "DEPLOYMENT_PROJECT_ITEM", "DEPLOYMENT_PROJECT_ITEM_BA", "DEPLOYMENT_RESULT", "DEPLOYMENT_RESULT_CUSTOMDATA", "DEPLOYMENT_VARIABLE_SUBS", "DEPLOYMENT_VERSION", "DEPLOYMENT_VERSION_CHANGESET", "DEPLOYMENT_VERSION_COMMIT", "DEPLOYMENT_VERSION_ITEM", "DEPLOYMENT_VERSION_ITEM_BA", "DEPLOYMENT_VERSION_JIRA_ISSUE", "DEPLOYMENT_VERSION_NAMING", "DEPLOYMENT_VERSION_STATUS", "DEP_VERSION_PLANRESULTKEYS", "EC2_IMAGE_SCRIPT", "ELASTIC_IMAGE", "ELASTIC_SCHEDULE", "EXTERNAL_ENTITIES", "EXTERNAL_MEMBERS", "GROUPS", "ID_GENERATOR", "IMSERVER", "LABEL", "LOCAL_MEMBERS", "MERGE_RESULT", "NOTIFICATIONS", "NOTIFICATION_SETS", "ORPHANED_TESTS_CLEANUP_JOB", "OS_PROPERTYENTRY", "PASSWORD_RESET_TOKEN", "PLAN_DEPENDENCIES", "PLAN_VCS_HISTORY", "PLAN_VCS_LOCATION", "PROJECT", "QUEUE", "QUICK_FILTERS", "QUICK_FILTER_RULES", "RELEVANT_CHANGESETS", "REMEMBERME_TOKEN", "REPOSITORY_CHANGESET", "REQUIREMENT", "REQUIREMENT_SET", "SCRIPT", "STAGE_VARIABLE_CONTEXT", "TEST_CASE", "TEST_CASE_RESULT", "TEST_CLASS", "TEST_CLASS_RESULT", "TEST_ERROR", "TRUSTED_APPS", "TRUSTED_APPS_IPS", "TRUSTED_APPS_URLS", "TRUSTED_KEY", "USERS", "USER_COMMENT", "USER_COMMIT", "VARIABLESTOAUTOINCREMENT", "VARIABLE_BASELINE_ITEM", "VARIABLE_CONTEXT", "VARIABLE_CONTEXT_BASELINE", "VARIABLE_DEFINITION", "VARIABLE_SUBSTITUTION", "VCS_BRANCH", "VCS_LOCATION"};
    @Autowired
    private DbmsBean dbmsBean;

    public UpgradeTask51509DropHibernate2FkConstraints() {
        super("Drop all FK constraints created by an older Hibernate version");
    }

    public void doUpgrade() throws Exception {
        this.withDatabaseConnection(c -> {
            HashMultimap<String, String> fksPreDrop = ForeignKeyConstraintUtils.getAllForeignKeyConstraints(this.dbmsBean, c, Arrays.stream(TABLES).filter(t -> {
                try {
                    return this.dbmsBean.isTablePresent(c, t);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList()));
            fksPreDrop.entries().forEach(entry -> {
                String constraint = (String)entry.getValue();
                if (!StringUtils.startsWithIgnoreCase((CharSequence)constraint, (CharSequence)"fk_")) {
                    ForeignKeyConstraintUtils.dropForeignKeyConstraint(this.dbmsBean, c, (String)entry.getKey(), constraint);
                }
            });
        });
    }
}

