/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_15;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.google.common.collect.ImmutableMultimap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask51507ResizeChangesetColumns
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask51507ResizeChangesetColumns.class);
    @Autowired
    private DbmsBean dbmsBean;
    private static final ImmutableMultimap<String, String> CHANGESET_COLUMNS = ImmutableMultimap.builder().put((Object)"DEPLOYMENT_VERSION_CHANGESET", (Object)"CHANGESET_ID").put((Object)"DEPLOYMENT_VERSION_COMMIT", (Object)"COMMIT_REVISION").put((Object)"USER_COMMIT", (Object)"COMMIT_REVISION").put((Object)"BRANCH_COMMIT_INFO", (Object)"CREATING_CHANGE_SET_ID").put((Object)"BRANCH_COMMIT_INFO", (Object)"LATEST_COMMIT_CHANGE_SET_ID").put((Object)"COMMIT_FILES", (Object)"COMMIT_FILE_REIVISION").put((Object)"REPOSITORY_CHANGESET", (Object)"CHANGESET_ID").build();

    public UpgradeTask51507ResizeChangesetColumns() {
        super("Resize changeset columns");
    }

    public void doUpgrade() throws Exception {
        this.withDatabaseConnection(connection -> {
            for (Map.Entry entry : CHANGESET_COLUMNS.entries()) {
                String columnName;
                String tableName = (String)entry.getKey();
                if (this.dbmsBean.isColumnPresent(connection, tableName, columnName = (String)entry.getValue())) {
                    this.dbmsBean.resizeVarcharColumn(connection, (String)entry.getKey(), (String)entry.getValue(), 128, true, null);
                    continue;
                }
                log.info((Object)String.format("Skipping upgrade of column %s.%s - either table or column doesn't exist", tableName, columnName));
            }
        });
    }
}

