/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_15;

import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.credentials.Credentials;
import com.atlassian.bamboo.credentials.CredentialsDao;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.credentials.MutableCredentialsData;
import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.security.MigratingEncryptionService;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class UpgradeTask51506ReEncryptSharedCredentials
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask51506ReEncryptSharedCredentials.class);
    private static final Map<String, Set<String>> FIELDS_TO_RE_ENCRYPT = ImmutableMap.of((Object)"com.atlassian.bamboo.plugin.sharedCredentials:usernamePasswordCredentials", (Object)ImmutableSet.of((Object)"password"), (Object)"com.atlassian.bamboo.plugin.sharedCredentials:sshCredentials", (Object)ImmutableSet.of((Object)"sshKey", (Object)"sshPassphrase"), (Object)"com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-aws-credentials:awsCredentials", (Object)ImmutableSet.of((Object)"secretKey"));
    @Autowired
    private CredentialsDao credentialsDao;
    @Lazy
    @Autowired
    private SecretEncryptionService secretEncryptionService;
    private MigratingEncryptionService migratingEncryptionService;

    protected UpgradeTask51506ReEncryptSharedCredentials() {
        super("Re-encrypting shared credentials using new encryption service");
    }

    public void doUpgrade() throws Exception {
        this.migratingEncryptionService = new MigratingEncryptionService(this.secretEncryptionService);
        this.credentialsDao.findAll().forEach(this::upgradeCredentials);
    }

    @VisibleForTesting
    void upgradeCredentials(@NotNull MutableCredentialsData credentialsData) {
        Map<String, String> upgradedConfiguration;
        String pluginKey = credentialsData.getPluginKey();
        if (!FIELDS_TO_RE_ENCRYPT.keySet().contains(pluginKey)) {
            log.debug((Object)("Skipping upgrade of shared credentials - unknown plugin key " + this.logCredentials((CredentialsData)credentialsData)));
            return;
        }
        Map existingConfiguration = credentialsData.getConfiguration();
        if (existingConfiguration.equals(upgradedConfiguration = this.upgradeConfiguration(pluginKey, existingConfiguration))) {
            log.debug((Object)("Skipping upgrade of shared credentials - already upgraded " + this.logCredentials((CredentialsData)credentialsData)));
        } else {
            log.debug((Object)("Upgrading shared credentials " + this.logCredentials((CredentialsData)credentialsData)));
            credentialsData.setXml(Credentials.configToXml(upgradedConfiguration));
            this.credentialsDao.save((BambooObject)credentialsData);
        }
    }

    private Map<String, String> upgradeConfiguration(@NotNull String pluginKey, @NotNull Map<String, String> existingConfiguration) {
        HashMap<String, String> upgradedConfiguration = new HashMap<String, String>();
        Set<String> fieldsToReEncrypt = FIELDS_TO_RE_ENCRYPT.get(pluginKey);
        for (Map.Entry<String, String> configEntry : existingConfiguration.entrySet()) {
            String upgradedValue = fieldsToReEncrypt.contains(configEntry.getKey()) ? this.migratingEncryptionService.encrypt(this.migratingEncryptionService.decrypt(configEntry.getValue())) : configEntry.getValue();
            upgradedConfiguration.put(configEntry.getKey(), upgradedValue);
        }
        return upgradedConfiguration;
    }

    private String logCredentials(@NotNull CredentialsData credentialsData) {
        return String.format("(id: %d, plugin: %s)", credentialsData.getId(), credentialsData.getName());
    }

    static interface AwsCredentials {
        public static final String PLUGIN_KEY = "com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-aws-credentials:awsCredentials";
        public static final String CFG_ACCESS_KEY = "accessKey";
        public static final String CFG_SECRET_KEY = "secretKey";
    }

    static interface SshCredentials {
        public static final String PLUGIN_KEY = "com.atlassian.bamboo.plugin.sharedCredentials:sshCredentials";
        public static final String CFG_SSH_KEY = "sshKey";
        public static final String CFG_SSH_PASSPHRASE = "sshPassphrase";
    }

    static interface PasswordCredentials {
        public static final String PLUGIN_KEY = "com.atlassian.bamboo.plugin.sharedCredentials:usernamePasswordCredentials";
        public static final String CFG_USERNAME = "username";
        public static final String CFG_PASSWORD = "password";
    }
}

