/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_15;

import com.atlassian.bamboo.collections.message.FinalHashMap;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDataEntityImpl;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import com.atlassian.bamboo.security.EncryptionException;
import com.atlassian.bamboo.security.MigratingEncryptionService;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataBuilder;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataImpl;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfiguration;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfigurationXmlConverter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSortedSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class UpgradeTask51505EncryptRepositoryDefinition
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask51505EncryptRepositoryDefinition.class);
    private static final int PAGE_SIZE = 100;
    private static final Set<String> ENCRYPTED_KEYS = ImmutableSortedSet.of((Comparable)((Object)StringUtils.lowerCase((String)"repository.bitbucket.password", (Locale)Locale.ENGLISH)), (Comparable)((Object)StringUtils.lowerCase((String)"repository.bitbucket.sshKey", (Locale)Locale.ENGLISH)), (Comparable)((Object)StringUtils.lowerCase((String)"repository.bitbucket.sshPassphrase", (Locale)Locale.ENGLISH)), (Comparable)((Object)StringUtils.lowerCase((String)"repository.git.password", (Locale)Locale.ENGLISH)), (Comparable)((Object)StringUtils.lowerCase((String)"repository.git.ssh.key", (Locale)Locale.ENGLISH)), (Comparable)((Object)StringUtils.lowerCase((String)"repository.git.ssh.passphrase", (Locale)Locale.ENGLISH)), (Comparable[])new String[]{StringUtils.lowerCase((String)"repository.github.password", (Locale)Locale.ENGLISH), StringUtils.lowerCase((String)"repository.hg.password.password", (Locale)Locale.ENGLISH), StringUtils.lowerCase((String)"repository.hg.ssh_proxy.privateKey", (Locale)Locale.ENGLISH), StringUtils.lowerCase((String)"repository.hg.ssh_proxy.passphrase", (Locale)Locale.ENGLISH), StringUtils.lowerCase((String)"repository.hg.keyfile.privateKey", (Locale)Locale.ENGLISH), StringUtils.lowerCase((String)"repository.svn.userPassword", (Locale)Locale.ENGLISH), StringUtils.lowerCase((String)"repository.svn.passphrase", (Locale)Locale.ENGLISH), StringUtils.lowerCase((String)"repository.svn.sslPassphrase", (Locale)Locale.ENGLISH), StringUtils.lowerCase((String)"repository.cvs.password", (Locale)Locale.ENGLISH), StringUtils.lowerCase((String)"repository.cvs.passphrase", (Locale)Locale.ENGLISH), StringUtils.lowerCase((String)"repository.p4.password", (Locale)Locale.ENGLISH), StringUtils.lowerCase((String)"repository.stash.key.private", (Locale)Locale.ENGLISH)});
    @Autowired
    private RepositoryDefinitionDao repositoryDefinitionDao;
    @Autowired
    private BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate;
    @Autowired
    @Lazy
    private SecretEncryptionService secretEncryptionService;
    @Autowired
    private RawRepositoryConfigurationXmlConverter rawRepositoryConfigurationXmlConverter;
    private MigratingEncryptionService migratingEncryptionService;

    public UpgradeTask51505EncryptRepositoryDefinition() {
        super("Encrypt secure fields of repository definitions");
    }

    public void doUpgrade() throws Exception {
        long size = this.repositoryDefinitionDao.countAll();
        AtomicInteger count = new AtomicInteger(0);
        int i = 0;
        while ((long)i < size) {
            int startIndex = i;
            try {
                this.bambooTransactionHibernateTemplate.execute(session -> {
                    List repositories = this.fetchRepositories(startIndex, session);
                    for (Object o : repositories) {
                        RepositoryDataEntityImpl repository = (RepositoryDataEntityImpl)o;
                        boolean updated = this.processRepository(repository);
                        if (!updated) continue;
                        log.info((Object)("Reencrypted properties of '" + repository.getName() + "' (" + repository.getId() + ")"));
                        count.incrementAndGet();
                    }
                    log.info((Object)("Processed " + (startIndex + repositories.size()) + " records of " + size));
                    return null;
                });
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            i += 100;
        }
        log.info((Object)("Finished reencryption of repository data, updated " + count.get() + " records of " + size));
    }

    @VisibleForTesting
    boolean processRepository(RepositoryDataEntityImpl repository) {
        RawRepositoryConfiguration configuration = this.rawRepositoryConfigurationXmlConverter.fromEntity((RepositoryDataEntity)repository);
        boolean updated = StringUtils.isNotBlank((CharSequence)configuration.getLegacyXml()) ? this.updateLegacyRepository(repository, configuration) : this.updateRepository(repository, configuration);
        if (updated) {
            this.repositoryDefinitionDao.save((BambooObject)repository);
        }
        return updated;
    }

    private List fetchRepositories(int startIndex, Session session) {
        Criteria criteria = session.createCriteria(RepositoryDataEntityImpl.class);
        criteria.setFirstResult(startIndex);
        criteria.addOrder(Order.asc((String)"id"));
        criteria.setMaxResults(100);
        return criteria.list();
    }

    private boolean updateRepository(RepositoryDataEntityImpl repository, RawRepositoryConfiguration configuration) {
        boolean updated = false;
        Map serverConfiguration = configuration.getServerConfiguration();
        if (serverConfiguration != null) {
            HashMap updatedServerConfiguration = new HashMap();
            for (Map.Entry entry : serverConfiguration.entrySet()) {
                if (this.shouldBeMasked((String)entry.getKey())) {
                    String value = this.decryptValue((String)entry.getValue());
                    if (StringUtils.isEmpty((CharSequence)value)) {
                        updatedServerConfiguration.put(entry.getKey(), "");
                    } else {
                        updatedServerConfiguration.put(entry.getKey(), this.getMigratingEncryptionService().encrypt(value));
                    }
                    updated = true;
                    continue;
                }
                updatedServerConfiguration.put(entry.getKey(), (String)entry.getValue());
            }
            if (updated) {
                PartialVcsRepositoryData partialVcsRepositoryData = PartialVcsRepositoryDataBuilder.newBuilder().fullCopy((PartialVcsRepositoryData)new PartialVcsRepositoryDataImpl((RepositoryDataEntity)repository, configuration, null)).serverConfiguration((Map)new FinalHashMap(updatedServerConfiguration)).build();
                repository.setXmlData(this.rawRepositoryConfigurationXmlConverter.asXml(partialVcsRepositoryData));
            }
        }
        return updated;
    }

    @NotNull
    private String decryptValue(String value) {
        try {
            return this.getMigratingEncryptionService().decrypt(value);
        }
        catch (EncryptionException e) {
            log.info((Object)"Couldn't decrypt value, it might be stored already decrypted");
            log.info((Object)e.getMessage(), (Throwable)e);
            return value;
        }
    }

    private boolean updateLegacyRepository(@NotNull RepositoryDataEntityImpl repository, @NotNull RawRepositoryConfiguration configuration) {
        boolean updated = false;
        PartialVcsRepositoryDataBuilder builder = PartialVcsRepositoryDataBuilder.newBuilder().fullCopy((PartialVcsRepositoryData)new PartialVcsRepositoryDataImpl((RepositoryDataEntity)repository, configuration, null));
        XMLConfiguration legacyConfig = ConfigUtils.getXmlConfigFromXmlString((String)configuration.getLegacyXml());
        Iterator iter = legacyConfig.getKeys();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            if (!this.shouldBeMasked(key)) continue;
            String originalValue = this.decryptValue(legacyConfig.getString(key));
            if (StringUtils.isEmpty((CharSequence)originalValue)) {
                legacyConfig.setProperty(key, (Object)"");
            } else {
                legacyConfig.setProperty(key, (Object)this.getMigratingEncryptionService().encrypt(originalValue));
            }
            updated = true;
        }
        if (updated) {
            builder.legacyXml(ConfigUtils.asXmlString((XMLConfiguration)legacyConfig));
            repository.setXmlData(this.rawRepositoryConfigurationXmlConverter.asXml(builder.build()));
        }
        return updated;
    }

    private MigratingEncryptionService getMigratingEncryptionService() {
        if (this.migratingEncryptionService == null) {
            this.migratingEncryptionService = new MigratingEncryptionService(this.secretEncryptionService);
        }
        return this.migratingEncryptionService;
    }

    @VisibleForTesting
    void setMigratingEncryptionService(MigratingEncryptionService migratingEncryptionService) {
        this.migratingEncryptionService = migratingEncryptionService;
    }

    private boolean shouldBeMasked(@NotNull String key) {
        return ENCRYPTED_KEYS.contains(StringUtils.lowerCase((String)key, (Locale)Locale.ENGLISH));
    }
}

