/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_15;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask51502UniqueSharedCredentialNames
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask51502UniqueSharedCredentialNames.class);
    @Autowired
    private DbmsBean dbmsBean;

    public UpgradeTask51502UniqueSharedCredentialNames() {
        super("Updating shared credential names to be unique");
    }

    public void doUpgrade() throws Exception {
        this.withDatabaseConnection(connection -> {
            if (!this.dbmsBean.isTablePresent(connection, "CREDENTIALS")) {
                return;
            }
            Map<Long, String> allCredentials = UpgradeTask51502UniqueSharedCredentialNames.getAllCredentials(connection);
            Map<Long, String> credentialsToUpdate = UpgradeTask51502UniqueSharedCredentialNames.getCredentialsToUpdate(allCredentials);
            log.info((Object)String.format("Updating names of %d shared credentials", credentialsToUpdate.size()));
            for (Map.Entry<Long, String> credentialToUpdate : credentialsToUpdate.entrySet()) {
                long credentialId = credentialToUpdate.getKey();
                String newCredentialName = credentialToUpdate.getValue();
                UpgradeTask51502UniqueSharedCredentialNames.updateCredentialName(connection, credentialId, newCredentialName);
            }
            log.info((Object)"Adding unique name constraint on shared credentials table");
            UpgradeTask51502UniqueSharedCredentialNames.addUniqueNameConstraint(connection);
            log.info((Object)"Finished updating shared credentials to have unique names");
        });
    }

    private static Map<Long, String> getAllCredentials(Connection connection) throws SQLException {
        LinkedHashMap<Long, String> allSharedCredentials = new LinkedHashMap<Long, String>();
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("select CREDENTIALS_ID, NAME from CREDENTIALS order by CREDENTIALS_ID asc");){
            while (resultSet.next()) {
                long credentialId = resultSet.getLong(1);
                String credentialName = resultSet.getString(2);
                allSharedCredentials.put(credentialId, credentialName);
            }
        }
        return allSharedCredentials;
    }

    @VisibleForTesting
    static Map<Long, String> getCredentialsToUpdate(Map<Long, String> allCredentials) {
        HashMap<Long, String> credentialNamesToUpdate = new HashMap<Long, String>();
        HashSet<String> existingNames = new HashSet<String>(allCredentials.values());
        HashSet alreadyUsedNames = new HashSet();
        allCredentials.forEach((credentialId, credentialName) -> {
            if (!alreadyUsedNames.add(credentialName)) {
                String newCredentialName = UpgradeTask51502UniqueSharedCredentialNames.getNewCredentialName(credentialName, existingNames, alreadyUsedNames);
                credentialNamesToUpdate.put((Long)credentialId, newCredentialName);
                alreadyUsedNames.add(newCredentialName);
            }
        });
        return credentialNamesToUpdate;
    }

    private static String getNewCredentialName(String currentName, Set<String> existingNames, Set<String> alreadyUsedNames) {
        String newCredentialName;
        UniqueNameProvider uniqueNameProvider = new UniqueNameProvider(currentName);
        while (alreadyUsedNames.contains(newCredentialName = uniqueNameProvider.nextUniqueName()) || existingNames.contains(newCredentialName)) {
        }
        return newCredentialName;
    }

    private static void updateCredentialName(Connection connection, long credentialId, String newCredentialName) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("update CREDENTIALS set NAME = ? where CREDENTIALS_ID = ?");){
            statement.setString(1, newCredentialName);
            statement.setLong(2, credentialId);
            statement.executeUpdate();
        }
    }

    private static void addUniqueNameConstraint(Connection connection) {
        try (Statement statement = connection.createStatement();){
            statement.execute("alter table CREDENTIALS add constraint unique_name_51501 unique (NAME)");
        }
        catch (SQLException e) {
            log.warn((Object)"Could not add unique name constraint on shared credentials table", (Throwable)e);
        }
    }

    @VisibleForTesting
    static class UniqueNameProvider {
        private final String originalName;
        int counter;

        public UniqueNameProvider(String originalName) {
            this.originalName = originalName;
            this.counter = 1;
        }

        public String nextUniqueName() {
            String nextName = String.format("%s (%d)", this.originalName, this.counter);
            ++this.counter;
            return nextName;
        }
    }
}

