/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_14;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.plan.PlanDao;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.branch.BambooVcsBranchImpl;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchDao;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.repository.PlanRepositoryLink;
import com.atlassian.bamboo.repository.PlanRepositoryLinkDao;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import com.atlassian.bamboo.repository.svn.v2.configurator.SvnConfigurationConstants;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.utils.NameProvider;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataBuilder;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataImpl;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfiguration;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfigurationXmlConverter;
import com.atlassian.bamboo.vcs.configuration.service.VcsRepositoryConfigurationService;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask51416FixSvnVcsBranch
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask51416FixSvnVcsBranch.class);
    private static final int PAGE_SIZE = 50;
    @Autowired
    private RepositoryDefinitionDao repositoryDefinitionDao;
    @Autowired
    private BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate;
    @Autowired
    private RawRepositoryConfigurationXmlConverter rawRepositoryConfigurationXmlConverter;
    @Autowired
    private VcsRepositoryConfigurationService vcsRepositoryConfigurationService;
    @Autowired
    private PlanDao planDao;
    @Autowired
    private VcsBranchDao vcsBranchDao;
    @Autowired
    private PlanRepositoryLinkDao planRepositoryLinkDao;

    public UpgradeTask51416FixSvnVcsBranch() {
        super("Fix Svn branch data where possible");
    }

    public void doUpgrade() throws Exception {
        long numberOfRepositories = this.repositoryDefinitionDao.countAllByParent(null);
        int i = 0;
        while ((long)i < numberOfRepositories) {
            int firstResult = i;
            this.bambooTransactionHibernateTemplate.doWork(connection -> {
                Collection repositories = this.repositoryDefinitionDao.findAllByParent(null, firstResult, 50);
                this.fixVcsBranch(repositories, null);
            });
            i += 50;
        }
        long numberOfChains = this.planDao.getPlanCount(TopLevelPlan.class);
        int i2 = 0;
        while ((long)i2 < numberOfChains) {
            int firstResult = i2;
            this.bambooTransactionHibernateTemplate.doWork(connection -> this.planDao.findAllPlans(TopLevelPlan.class, firstResult, 50).forEach(this::addBambooVcsBranches));
            i2 += 50;
        }
    }

    private void addBambooVcsBranches(TopLevelPlan topLevelPlan) {
        List repositoryLinks = this.planRepositoryLinkDao.getPlanRepositoryLinks((ImmutablePlan)topLevelPlan);
        if (!repositoryLinks.isEmpty()) {
            RepositoryDataEntity repositoryDataEntity = ((PlanRepositoryLink)repositoryLinks.get(0)).getRepositoryDataEntity();
            if (!"com.atlassian.bamboo.plugin.system.repository:svnv2".equals(repositoryDataEntity.getPluginKey())) {
                return;
            }
            Set existingBranchEntries = BambooIterables.stream((Iterable)this.vcsBranchDao.findByChain((ImmutableChain)topLevelPlan)).map(NameProvider::getName).collect(Collectors.toSet());
            long numberOfRepositories = this.repositoryDefinitionDao.countAllByParent(Long.valueOf(repositoryDataEntity.getId()));
            int i = 0;
            while ((long)i < numberOfRepositories) {
                int firstResult = i;
                Collection children = this.repositoryDefinitionDao.findAllByParent(Long.valueOf(repositoryDataEntity.getId()), firstResult, 50);
                for (RepositoryDataEntity child : children) {
                    String branchName;
                    RawRepositoryConfiguration configuration;
                    if (!"com.atlassian.bamboo.plugin.system.repository:svnv2".equals(repositoryDataEntity.getPluginKey()) || MapUtils.isEmpty((Map)(configuration = this.rawRepositoryConfigurationXmlConverter.fromEntity(child)).getBranchConfiguration()) || (branchName = (String)StringUtils.defaultIfBlank((CharSequence)((CharSequence)configuration.getBranchConfiguration().get(SvnConfigurationConstants.SVN_BRANCH_PATH)), (CharSequence)"")).isEmpty() || existingBranchEntries.contains(branchName)) continue;
                    BambooVcsBranchImpl bambooVcsBranch = new BambooVcsBranchImpl((Chain)topLevelPlan, (VcsBranch)new VcsBranchImpl(branchName));
                    this.vcsBranchDao.save((BambooObject)bambooVcsBranch);
                    existingBranchEntries.add(branchName);
                }
                i += 50;
            }
        }
    }

    private void fixVcsBranch(Collection<? extends RepositoryDataEntity> repositories, PartialVcsRepositoryData parent) {
        for (RepositoryDataEntity repositoryDataEntity : repositories) {
            if (!"com.atlassian.bamboo.plugin.system.repository:svnv2".equals(repositoryDataEntity.getPluginKey())) continue;
            PartialVcsRepositoryDataImpl repositoryData = new PartialVcsRepositoryDataImpl(repositoryDataEntity, this.rawRepositoryConfigurationXmlConverter.fromEntity(repositoryDataEntity), parent == null ? null : parent.getCompleteData());
            PartialVcsRepositoryData fixedRepositoryData = this.fixSingleRepository((PartialVcsRepositoryData)repositoryData, repositoryDataEntity);
            long numberOfRepositories = this.repositoryDefinitionDao.countAllByParent(Long.valueOf(repositoryDataEntity.getId()));
            int i = 0;
            while ((long)i < numberOfRepositories) {
                int firstResult = i;
                this.bambooTransactionHibernateTemplate.doWork(arg_0 -> this.lambda$fixVcsBranch$2(repositoryDataEntity, firstResult, (PartialVcsRepositoryData)repositoryData, arg_0));
                i += 50;
            }
        }
    }

    private PartialVcsRepositoryData fixSingleRepository(PartialVcsRepositoryData repositoryData, RepositoryDataEntity entity) {
        if (repositoryData.overridesBranch()) {
            Map branchConfig = repositoryData.getBranch().getConfiguration();
            VcsBranchImpl vcsBranch = new VcsBranchImpl((String)StringUtils.defaultIfBlank((CharSequence)((CharSequence)branchConfig.get(SvnConfigurationConstants.SVN_BRANCH_PATH)), (CharSequence)""), (String)StringUtils.defaultIfBlank((CharSequence)((CharSequence)branchConfig.get(SvnConfigurationConstants.SVN_BRANCH_DISPLAY_NAME)), (CharSequence)SvnConfigurationConstants.DEFAULT_BRANCH));
            PartialVcsRepositoryData newRepositoryData = PartialVcsRepositoryDataBuilder.newBuilder().fullCopy(repositoryData).vcsBranch((VcsBranch)vcsBranch).build();
            entity.setXmlData(this.rawRepositoryConfigurationXmlConverter.asXml(newRepositoryData));
            this.repositoryDefinitionDao.save((BambooObject)entity);
            return newRepositoryData;
        }
        return repositoryData;
    }

    private /* synthetic */ void lambda$fixVcsBranch$2(RepositoryDataEntity entity, int firstResult, PartialVcsRepositoryData repositoryData, Connection connection) throws SQLException {
        Collection children = this.repositoryDefinitionDao.findAllByParent(Long.valueOf(entity.getId()), firstResult, 50);
        this.fixVcsBranch(children, repositoryData);
    }
}

