/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_14;

import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataBuilder;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataImpl;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfigurationXmlConverter;
import com.atlassian.bamboo.vcs.configuration.service.VcsRepositoryConfigurationService;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask51415FixStashSshKeys
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask51415FixStashSshKeys.class);
    private static final int PAGE_SIZE = 50;
    private static final String SERVER = "repository.stash.server";
    private static final String PROJECT = "repository.stash.projectKey";
    private static final String REPOSITORY_ID = "repository.stash.repositoryId";
    private static final String PUBLIC_KEY = "repository.stash.key.public";
    private static final String PRIVATE_KEY = "repository.stash.key.private";
    private static final String IS_REPOSITORY_STORED_KEY = "repository.stash.key.isRepositoryStoredKey";
    @Autowired
    private RepositoryDefinitionDao repositoryDefinitionDao;
    @Autowired
    private BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate;
    @Autowired
    private RawRepositoryConfigurationXmlConverter rawRepositoryConfigurationXmlConverter;
    @Autowired
    private VcsRepositoryConfigurationService vcsRepositoryConfigurationService;

    public UpgradeTask51415FixStashSshKeys() {
        super("Fix Stash ssh keys in branches where possible");
    }

    public void doUpgrade() throws Exception {
        long numberOfRepositories = this.repositoryDefinitionDao.countAllByParent(null);
        int i = 0;
        while ((long)i < numberOfRepositories) {
            int firstResult = i;
            this.bambooTransactionHibernateTemplate.doWork(connection -> {
                Collection repositories = this.repositoryDefinitionDao.findAllByParent(null, firstResult, 50);
                this.fixSshKeys(repositories, null);
            });
            i += 50;
        }
    }

    private void fixSshKeys(Collection<? extends RepositoryDataEntity> repositories, PartialVcsRepositoryData parent) {
        for (RepositoryDataEntity repositoryDataEntity : repositories) {
            if (!"com.atlassian.bamboo.plugins.stash.atlassian-bamboo-plugin-stash:bbserver".equals(repositoryDataEntity.getPluginKey())) continue;
            PartialVcsRepositoryDataImpl repositoryData = new PartialVcsRepositoryDataImpl(repositoryDataEntity, this.rawRepositoryConfigurationXmlConverter.fromEntity(repositoryDataEntity), parent == null ? null : parent.getCompleteData());
            PartialVcsRepositoryData fixedRepositoryData = this.fixSingleRepository((PartialVcsRepositoryData)repositoryData, repositoryDataEntity);
            long numberOfRepositories = this.repositoryDefinitionDao.countAllByParent(Long.valueOf(repositoryDataEntity.getId()));
            int i = 0;
            while ((long)i < numberOfRepositories) {
                int firstResult = i;
                this.bambooTransactionHibernateTemplate.doWork(arg_0 -> this.lambda$fixSshKeys$1(repositoryDataEntity, firstResult, (PartialVcsRepositoryData)repositoryData, arg_0));
                i += 50;
            }
        }
    }

    private PartialVcsRepositoryData fixSingleRepository(PartialVcsRepositoryData repositoryData, RepositoryDataEntity entity) {
        if (repositoryData.overridesLocation() && repositoryData.getInheritedData() != null) {
            Map inheritedConfiguration = repositoryData.getInheritedData().getVcsLocation().getConfiguration();
            HashMap newConfiguration = new HashMap(repositoryData.getVcsLocation().getConfiguration());
            if (((String)inheritedConfiguration.get(SERVER)).equals(newConfiguration.get(SERVER)) && ((String)inheritedConfiguration.get(PROJECT)).equals(newConfiguration.get(PROJECT)) && ((String)inheritedConfiguration.get(REPOSITORY_ID)).equals(newConfiguration.get(REPOSITORY_ID))) {
                newConfiguration.put(PUBLIC_KEY, inheritedConfiguration.get(PUBLIC_KEY));
                newConfiguration.put(PRIVATE_KEY, inheritedConfiguration.get(PRIVATE_KEY));
                if (inheritedConfiguration.containsKey(IS_REPOSITORY_STORED_KEY)) {
                    newConfiguration.put(IS_REPOSITORY_STORED_KEY, inheritedConfiguration.get(IS_REPOSITORY_STORED_KEY));
                } else {
                    newConfiguration.remove(IS_REPOSITORY_STORED_KEY);
                }
                PartialVcsRepositoryData newRepositoryData = PartialVcsRepositoryDataBuilder.newBuilder().fullCopy(repositoryData).serverConfiguration(newConfiguration.equals(inheritedConfiguration) ? null : newConfiguration).build();
                StringBuilder logMessage = new StringBuilder("Resetting ssh key in repository ").append(repositoryData.getId());
                if (repositoryData.getBranch() != null) {
                    logMessage.append(", branch ").append(repositoryData.getBranch().getVcsBranch().getName());
                }
                log.info((Object)logMessage.toString());
                entity.setXmlData(this.rawRepositoryConfigurationXmlConverter.asXml(newRepositoryData));
                this.repositoryDefinitionDao.save((BambooObject)entity);
                return newRepositoryData;
            }
        }
        return repositoryData;
    }

    private /* synthetic */ void lambda$fixSshKeys$1(RepositoryDataEntity entity, int firstResult, PartialVcsRepositoryData repositoryData, Connection connection) throws SQLException {
        Collection children = this.repositoryDefinitionDao.findAllByParent(Long.valueOf(entity.getId()), firstResult, 50);
        this.fixSshKeys(children, repositoryData);
    }
}

