/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_14;

import com.atlassian.bamboo.build.BuildDefinitionForBuild;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.plan.PlanDao;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.repository.PlanRepositoryLinkDao;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.repository.svn.v2.configurator.SvnConfigurationConstants;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataBuilder;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfigurationXmlConverter;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask51408MoveSvnBranchDetectionConfigurationToVcsData
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask51408MoveSvnBranchDetectionConfigurationToVcsData.class);
    private static final int PAGE_SIZE = 50;
    private static final String BRANCHES_ROOT_OVERRIDDEN_KEY = "branches.custom.branchesRootOverridden";
    private static final String BRANCHES_ROOT_KEY = "branches.custom.branchesRoot";
    @Autowired
    private RepositoryDefinitionDao repositoryDefinitionDao;
    @Autowired
    private PlanDao planDao;
    @Autowired
    PlanRepositoryLinkDao planRepositoryLinkDao;
    @Autowired
    private BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate;
    @Autowired
    private RawRepositoryConfigurationXmlConverter rawRepositoryConfigurationXmlConverter;
    @Autowired
    private RepositoryDefinitionManager repositoryDefinitionManager;

    public UpgradeTask51408MoveSvnBranchDetectionConfigurationToVcsData() {
        super("Move branch detection configuration from build configuration");
    }

    public void doUpgrade() throws Exception {
        long topLevelPlanCount = this.planDao.countAll(TopLevelPlan.class);
        int i = 0;
        while ((long)i < topLevelPlanCount) {
            int firstResult = i;
            this.bambooTransactionHibernateTemplate.doWork(connection -> {
                List plans = this.planDao.findAllPlans(TopLevelPlan.class, firstResult, 50);
                this.convertPlans(plans);
            });
            i += 50;
        }
    }

    private void convertPlans(Collection<TopLevelPlan> plans) {
        for (TopLevelPlan plan : plans) {
            PlanRepositoryDefinition defaultRepository = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)plan);
            if (defaultRepository == null || !defaultRepository.getPluginKey().equals("com.atlassian.bamboo.plugin.system.repository:svnv2")) continue;
            BuildDefinitionForBuild buildDefinitionXml = plan.getBuildDefinitionXml();
            BuildConfiguration buildConfiguration = new BuildConfiguration(buildDefinitionXml.getXmlData());
            RepositoryDataEntity repositoryDataEntity = this.repositoryDefinitionDao.findById(defaultRepository.getId());
            PartialVcsRepositoryData partialVcsRepositoryData = this.repositoryDefinitionManager.entityToUnmergedData(repositoryDataEntity);
            HashMap<String, String> branchDetectionConfiguration = new HashMap<String, String>();
            boolean overrideBranchPath = buildConfiguration.getBoolean(BRANCHES_ROOT_OVERRIDDEN_KEY, false);
            branchDetectionConfiguration.put(SvnConfigurationConstants.BRANCH_DETECTION_PATH_OVERRIDDEN, Boolean.toString(overrideBranchPath));
            if (overrideBranchPath) {
                String rootUrl;
                String branchPath = buildConfiguration.getString(BRANCHES_ROOT_KEY, "");
                if (branchPath.startsWith(rootUrl = (String)partialVcsRepositoryData.getCompleteData().getVcsLocation().getConfiguration().get(SvnConfigurationConstants.SVN_REPO_ROOT_URL))) {
                    branchPath = branchPath.substring(rootUrl.length());
                }
                branchDetectionConfiguration.put(SvnConfigurationConstants.BRANCH_DETECTION_PATH, branchPath);
            }
            PartialVcsRepositoryDataBuilder builder = PartialVcsRepositoryDataBuilder.newBuilder().fullCopy(partialVcsRepositoryData);
            builder.branchDetectionConfiguration(branchDetectionConfiguration);
            repositoryDataEntity.setXmlData(this.rawRepositoryConfigurationXmlConverter.asXml(builder.build()));
            this.repositoryDefinitionDao.save((BambooObject)repositoryDataEntity);
        }
    }
}

