/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_14;

import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.repository.LegacyRepositoryConfigurationUtils;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.vcs.configuration.legacy.configurator.LegacyBranchConfigurator;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfiguration;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfigurationImpl;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfigurationXmlConverter;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfigurationXmlConverterImpl;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.webrepository.WebRepositoryViewer;
import com.atlassian.bamboo.webrepository.WebRepositoryViewerManager;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask51406UseNewXmlFormatForRepositories
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask51406UseNewXmlFormatForRepositories.class);
    private static final int PAGE_SIZE = 100;
    @Autowired
    private RepositoryDefinitionDao repositoryDefinitionDao;
    @Autowired
    private BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate;
    @Autowired
    private VcsRepositoryManager vcsRepositoryManager;
    @Autowired
    private WebRepositoryViewerManager webRepositoryViewerManager;
    @Autowired
    private RawRepositoryConfigurationXmlConverter rawRepositoryConfigurationXmlConverter;

    public UpgradeTask51406UseNewXmlFormatForRepositories() {
        super("Convert XML data in repositories to new format.");
    }

    public void doUpgrade() throws Exception {
        long numberOfRepositories = this.repositoryDefinitionDao.countAll();
        int i = 0;
        while ((long)i < numberOfRepositories) {
            int firstResult = i;
            this.bambooTransactionHibernateTemplate.doWork(connection -> {
                Collection repositories = this.repositoryDefinitionDao.findAll(firstResult, 100);
                this.convertXmlData(repositories);
            });
            i += 100;
        }
    }

    @VisibleForTesting
    protected RawRepositoryConfiguration getNewConfiguration(@NotNull RepositoryDataEntity repositoryDataEntity, @NotNull String xml, @NotNull String pluginKey) {
        boolean successful;
        RawRepositoryConfigurationImpl.Builder builder = RawRepositoryConfigurationImpl.builder().serverConfiguration(Collections.emptyMap()).legacyXml(xml);
        VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(pluginKey);
        if (vcsRepositoryModuleDescriptor == null) {
            log.warn((Object)("Could not find plugin " + pluginKey));
        } else if (vcsRepositoryModuleDescriptor.getVcsBranchConfigurator() != null) {
            LegacyBranchConfigurator legacyBranchConfigurator = (LegacyBranchConfigurator)vcsRepositoryModuleDescriptor.getVcsBranchConfigurator();
            VcsBranch vcsBranch = null;
            successful = false;
            try {
                vcsBranch = legacyBranchConfigurator.getVcsBranchFromRepositoryXml(xml);
                successful = true;
            }
            catch (Exception e) {
                log.warn((Object)("Error extracting branch name for repository " + repositoryDataEntity.getId()), (Throwable)e);
            }
            if (successful) {
                builder.vcsBranch(vcsBranch);
                builder.branchConfiguration(new HashMap());
            }
        }
        XMLConfiguration xmlConfiguration = ConfigUtils.getXmlConfigFromXmlString((String)xml);
        String webRepositoryViewerKey = xmlConfiguration.getString("selectedWebRepositoryViewer");
        builder.viewerConfiguration(new HashMap());
        if (StringUtils.isBlank((CharSequence)webRepositoryViewerKey) || "bamboo.webrepositoryviewer.provided:noRepositoryViewer".equals(webRepositoryViewerKey)) {
            builder.viewerPluginKey("none:none");
        } else {
            successful = false;
            WebRepositoryViewer webRepositoryViewer = this.webRepositoryViewerManager.getNewWebRepositoryViewerInstance(webRepositoryViewerKey);
            if (webRepositoryViewer != null) {
                try {
                    webRepositoryViewer.populateFromConfig((HierarchicalConfiguration)xmlConfiguration);
                    builder.viewerPluginKey(webRepositoryViewerKey);
                    builder.legacyViewerXml(ConfigUtils.asXmlString((HierarchicalConfiguration)webRepositoryViewer.toConfiguration()));
                    successful = true;
                }
                catch (Exception exception) {}
            } else {
                log.warn((Object)("No viewer plugin with key " + webRepositoryViewerKey));
            }
            if (!successful) {
                builder.viewerPluginKey(webRepositoryViewerKey);
                builder.legacyViewerXml(xml);
            }
        }
        Map changeDetectionConfig = LegacyRepositoryConfigurationUtils.extractChangeDetectionOptionFromConfiguration((HierarchicalConfiguration)xmlConfiguration);
        builder.changeDetectionConfiguration(changeDetectionConfig);
        return builder.build();
    }

    private void convertXmlData(Collection<? extends RepositoryDataEntity> repositories) {
        for (RepositoryDataEntity repositoryDataEntity : repositories) {
            if (RawRepositoryConfigurationXmlConverterImpl.isEntityIn514Format((RepositoryDataEntity)repositoryDataEntity)) continue;
            String xml = repositoryDataEntity.getXmlData();
            repositoryDataEntity.setXmlData(this.rawRepositoryConfigurationXmlConverter.asXml(this.getNewConfiguration(repositoryDataEntity, xml, repositoryDataEntity.getPluginKey())));
            this.repositoryDefinitionDao.save((BambooObject)repositoryDataEntity);
        }
    }
}

