/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_14;

import com.atlassian.bamboo.build.BuildDefinitionForBuild;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.fieldvalue.TaskConfigurationUtils;
import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanDao;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryStandaloneDao;
import com.atlassian.bamboo.repository.PlanRepositoryLink;
import com.atlassian.bamboo.repository.PlanRepositoryLinkDao;
import com.atlassian.bamboo.repository.PlanRepositoryLinkImpl;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDataEntityImpl;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.trigger.TriggerConfigurationUtils;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfigurationXmlConverter;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask51405SetParentInRepositories
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask51405SetParentInRepositories.class);
    private static final int PAGE_SIZE = 100;
    @Autowired
    private BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate;
    @Autowired
    private PlanDao planDao;
    @Autowired
    private PlanRepositoryLinkDao planRepositoryLinkDao;
    @Autowired
    private PlanVcsRevisionHistoryStandaloneDao planVcsRevisionHistoryDao;
    @Autowired
    private RawRepositoryConfigurationXmlConverter rawRepositoryConfigurationXmlConverter;
    @Autowired
    private RepositoryDefinitionDao repositoryDefinitionDao;
    @Autowired
    private TaskManager taskManager;

    public UpgradeTask51405SetParentInRepositories() {
        super("Create parent - child relationships in plan repositories");
    }

    public void doUpgrade() throws Exception {
        long numberOfChains = this.planDao.countAll(TopLevelPlan.class);
        int i = 0;
        while ((long)i < numberOfChains) {
            int firstResult = i;
            this.bambooTransactionHibernateTemplate.doWork(connection -> this.createRepositoryOverrideOnTopLevelPlan(this.planDao.findAllPlans(TopLevelPlan.class, firstResult, 100)));
            i += 100;
        }
        long numberOfBranches = this.planDao.countAll(ChainBranch.class);
        int i2 = 0;
        while ((long)i2 < numberOfBranches) {
            int firstResult = i2;
            this.bambooTransactionHibernateTemplate.doWork(connection -> this.addBranchRepositoryInheritance(this.planDao.findAllPlans(ChainBranch.class, firstResult, 100)));
            i2 += 100;
        }
    }

    private void createRepositoryOverrideOnTopLevelPlan(@NotNull List<TopLevelPlan> chains) {
        for (TopLevelPlan chain : chains) {
            List repositoryLinks = this.planRepositoryLinkDao.getPlanRepositoryLinks((ImmutablePlan)chain);
            for (PlanRepositoryLink repositoryLink : repositoryLinks) {
                if (!repositoryLink.getRepositoryDataEntity().isGlobal()) continue;
                RepositoryDataEntity globalRepository = repositoryLink.getRepositoryDataEntity();
                RepositoryDataEntityImpl repositoryEntity = new RepositoryDataEntityImpl(globalRepository);
                repositoryEntity.setParent(repositoryLink.getRepositoryDataEntity());
                repositoryEntity.setXmlData(this.rawRepositoryConfigurationXmlConverter.emptyXml());
                repositoryEntity.setGlobal(false);
                this.repositoryDefinitionDao.save((BambooObject)repositoryEntity);
                repositoryLink.setRepositoryDataEntity((RepositoryDataEntity)repositoryEntity);
                this.savePlanRepositoryLink(repositoryLink);
                for (Job job : chain.getAllJobs()) {
                    this.handleRepositoryIdChangeInJob(globalRepository, (RepositoryDataEntity)repositoryEntity, job);
                }
                BuildDefinitionForBuild buildDefinitionXml = chain.getBuildDefinitionXml();
                BuildConfiguration buildConfiguration = new BuildConfiguration(buildDefinitionXml.getXmlData());
                ImmutableList triggerDefinitions = TriggerConfigurationUtils.getTriggerDefinitionsFromConfig((HierarchicalConfiguration)buildConfiguration);
                if (CollectionUtils.isNotEmpty((Collection)triggerDefinitions)) {
                    TriggerConfigurationUtils.updateRepositoryIdsInTriggers((List)triggerDefinitions, (Map)ImmutableMap.of((Object)globalRepository.getId(), (Object)repositoryEntity.getId()));
                    TriggerConfigurationUtils.addTriggerDefinitionsToConfig((Iterable)triggerDefinitions, (HierarchicalConfiguration)buildConfiguration);
                    chain.getBuildDefinitionXml().setXmlData(buildConfiguration.asXml());
                    this.planDao.save((BambooObject)chain);
                }
                this.planVcsRevisionHistoryDao.updateRepositoryIdForPlan(chain.getPlanKey(), globalRepository.getId(), repositoryEntity.getId());
            }
        }
    }

    private void handleRepositoryIdChangeInJob(RepositoryDataEntity globalRepository, RepositoryDataEntity planRepositoryEntity, Job job) {
        BuildDefinitionForBuild buildDefinitionXml = job.getBuildDefinitionXml();
        BuildConfiguration buildConfiguration = new BuildConfiguration(buildDefinitionXml.getXmlData());
        long workingDirSelector = buildConfiguration.getLong("repositoryDefiningWorkingDirectory", -1L);
        if (workingDirSelector == globalRepository.getId()) {
            buildConfiguration.setProperty("repositoryDefiningWorkingDirectory", (Object)planRepositoryEntity.getId());
        }
        List tasks = TaskConfigurationUtils.getTaskDefinitionsFromConfig((String)"buildTasks.", (HierarchicalConfiguration)buildConfiguration);
        for (TaskDefinition taskDefinition : tasks) {
            this.taskManager.updateRepositoryIdsInTask(taskDefinition, (Map)ImmutableMap.of((Object)globalRepository.getId(), (Object)planRepositoryEntity.getId()));
        }
        TaskConfigurationUtils.removeTasksFromConfig((HierarchicalConfiguration)buildConfiguration);
        TaskConfigurationUtils.addTaskDefinitionsToConfig((List)tasks, (HierarchicalConfiguration)buildConfiguration, (String)"buildTasks.");
        job.getBuildDefinitionXml().setXmlData(buildConfiguration.asXml());
        this.planDao.save((BambooObject)job);
    }

    private void addBranchRepositoryInheritance(List<ChainBranch> chains) {
        for (ChainBranch chainBranch : chains) {
            RepositoryDataEntityImpl branchRepository;
            List branchRepositoryLinks = this.planRepositoryLinkDao.getPlanRepositoryLinks((ImmutablePlan)chainBranch);
            if (!branchRepositoryLinks.isEmpty() && ((PlanRepositoryLink)branchRepositoryLinks.get(0)).getRepositoryDataEntity().getParent() != null) continue;
            Chain master = chainBranch.getMaster();
            List masterRepositoryLinks = this.planRepositoryLinkDao.getPlanRepositoryLinks((ImmutablePlan)master);
            if (masterRepositoryLinks.isEmpty()) {
                log.warn((Object)("Chain branch on plan without repositories master: " + master.getPlanKey() + " branch: " + chainBranch.getPlanKey()));
                continue;
            }
            RepositoryDataEntity masterDefaultRepository = ((PlanRepositoryLink)masterRepositoryLinks.get(0)).getRepositoryDataEntity();
            if (branchRepositoryLinks.isEmpty()) {
                branchRepository = new RepositoryDataEntityImpl(masterDefaultRepository);
                branchRepository.setParent(masterDefaultRepository);
                branchRepository.setXmlData(this.rawRepositoryConfigurationXmlConverter.emptyXml());
                branchRepository.setGlobal(false);
                this.repositoryDefinitionDao.save((BambooObject)branchRepository);
                PlanRepositoryLinkImpl planRepositoryLink = new PlanRepositoryLinkImpl((Plan)chainBranch, (RepositoryDataEntity)branchRepository, 0);
                this.savePlanRepositoryLink((PlanRepositoryLink)planRepositoryLink);
                if (masterDefaultRepository.getParent() != null) {
                    this.planVcsRevisionHistoryDao.updateRepositoryIdForPlan(chainBranch.getPlanKey(), masterDefaultRepository.getParent().getId(), branchRepository.getId());
                    continue;
                }
                this.planVcsRevisionHistoryDao.updateRepositoryIdForPlan(chainBranch.getPlanKey(), masterDefaultRepository.getId(), branchRepository.getId());
                continue;
            }
            branchRepository = ((PlanRepositoryLink)branchRepositoryLinks.get(0)).getRepositoryDataEntity();
            branchRepository.setGlobal(false);
            branchRepository.setParent(masterDefaultRepository);
            this.repositoryDefinitionDao.save((BambooObject)branchRepository);
        }
    }

    private void savePlanRepositoryLink(PlanRepositoryLink planRepositoryLink) {
        RepositoryDataEntity repositoryDataEntity = planRepositoryLink.getRepositoryDataEntity();
        this.repositoryDefinitionDao.save((BambooObject)repositoryDataEntity);
        planRepositoryLink.setRepositoryDataEntity(this.repositoryDefinitionDao.findById(repositoryDataEntity.getId()));
        this.planRepositoryLinkDao.save((BambooObject)planRepositoryLink);
    }
}

