/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_14;

import com.atlassian.bamboo.build.BuildDefinitionForBuild;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.core.EntityWithOid;
import com.atlassian.bamboo.credentials.CredentialsDao;
import com.atlassian.bamboo.credentials.MutableCredentialsData;
import com.atlassian.bamboo.deployments.projects.persistence.DeploymentProjectDao;
import com.atlassian.bamboo.deployments.projects.persistence.MutableDeploymentProject;
import com.atlassian.bamboo.fieldvalue.TaskConfigurationUtils;
import com.atlassian.bamboo.plan.PlanDao;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionDao;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectDao;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.upgrade.tasks.v5_11.AbstractOidAddingUpgradeTask;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask51402ReseedServerKeyAndOids
extends AbstractOidAddingUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask51402ReseedServerKeyAndOids.class);
    private static final int PAGE_SIZE = 100;
    @Autowired
    private BootstrapManager bootstrapManager;
    @Autowired
    private PlanDao planDao;
    @Autowired
    private ProjectDao projectDao;
    @Autowired
    private RepositoryDefinitionDao repositoryDefinitionDao;
    @Autowired
    private ArtifactDefinitionDao artifactDefinitionDao;
    @Autowired
    private CredentialsDao credentialsDao;
    @Autowired
    private DeploymentProjectDao deploymentProjectDao;

    public UpgradeTask51402ReseedServerKeyAndOids() {
        super("Reseed server keys and fix oids");
    }

    public void doUpgrade() throws Exception {
        String serverID = this.bootstrapManager.getServerID();
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)serverID), (Object)"No server ID configured, can't initialize server key");
        int newServerKey = serverID.hashCode() & BambooEntityOid.SERVER_BITS_MASK;
        this.bootstrapManager.setServerKey(newServerKey);
        this.bootstrapManager.save();
        this.recalculateRepositoryOids(newServerKey);
        this.recalculateProjectOids(newServerKey);
        this.recalculateChainStageJobOids(newServerKey);
        this.recalculateArtifactsOid(newServerKey);
        this.recalculateCredentialsOid(newServerKey);
        this.recalculateDeploymentProjectsOid(newServerKey);
    }

    private void recalculateRepositoryOids(int newServerKey) {
        long numberOfRepositories = this.repositoryDefinitionDao.countAll();
        int i = 0;
        while ((long)i < numberOfRepositories) {
            int firstResult = i;
            this.bambooTransactionHibernateTemplate.doWork(connection -> {
                for (RepositoryDataEntity repository : this.repositoryDefinitionDao.findAll(firstResult, 100)) {
                    if (!this.recalculateOid((EntityWithOid)repository, newServerKey)) continue;
                    this.repositoryDefinitionDao.save((BambooObject)repository);
                }
            });
            i += 100;
        }
    }

    private void recalculateProjectOids(int newServerKey) {
        int numberOfProjects = this.projectDao.count().intValue();
        for (int i = 0; i < numberOfProjects; i += 100) {
            int firstResult = i;
            this.bambooTransactionHibernateTemplate.doWork(connection -> {
                for (Project project : this.projectDao.findAll(firstResult, 100)) {
                    if (!this.recalculateOid((EntityWithOid)project, newServerKey)) continue;
                    this.projectDao.save((BambooObject)project);
                }
            });
        }
    }

    private void recalculateChainStageJobOids(int newServerKey) {
        long numberOfChains = this.planDao.countAll(Chain.class);
        int i = 0;
        while ((long)i < numberOfChains) {
            int firstResult = i;
            this.bambooTransactionHibernateTemplate.doWork(connection -> {
                List chains = this.planDao.findAllPlans(Chain.class, firstResult, 100);
                this.recalculateChainStageJobOids(chains, newServerKey);
            });
            i += 100;
        }
    }

    private void recalculateChainStageJobOids(@NotNull List<Chain> chains, int newServerKey) {
        for (Chain chain : chains) {
            boolean changed = this.recalculateOid((EntityWithOid)chain, newServerKey);
            for (ChainStage stage : chain.getStages()) {
                changed |= this.recalculateOid((EntityWithOid)stage, newServerKey);
                for (Job job : stage.getJobs()) {
                    changed |= this.recalculateOid((EntityWithOid)job, newServerKey);
                    changed |= this.recalculateTasksOid(job, newServerKey);
                }
            }
            if (!changed) continue;
            this.planDao.save((BambooObject)chain);
        }
    }

    private boolean recalculateTasksOid(@NotNull Job job, int newServerKey) {
        boolean changed = false;
        if (!job.hasMaster() && job.getBuildDefinitionXml() != null) {
            BuildDefinitionForBuild buildDefinition = job.getBuildDefinitionXml();
            BuildConfiguration buildConfiguration = new BuildConfiguration(buildDefinition.getXmlData());
            List taskDefinitions = TaskConfigurationUtils.getTaskDefinitionsFromConfig((String)"buildTasks.", (HierarchicalConfiguration)buildConfiguration);
            for (TaskDefinition taskDefinition : taskDefinitions) {
                changed |= this.recalculateOid((EntityWithOid)taskDefinition, newServerKey);
            }
            TaskConfigurationUtils.removeTasksFromConfig((HierarchicalConfiguration)buildConfiguration);
            TaskConfigurationUtils.addTaskDefinitionsToConfig((List)taskDefinitions, (HierarchicalConfiguration)buildConfiguration, (String)"buildTasks.");
            buildDefinition.setXmlData(buildConfiguration.asXml());
        }
        return changed;
    }

    private void recalculateArtifactsOid(int newServerKey) {
        long numberOfArtifacts = this.artifactDefinitionDao.countAll(ArtifactDefinition.class);
        int i = 0;
        while ((long)i < numberOfArtifacts) {
            int firstResult = i;
            this.bambooTransactionHibernateTemplate.doWork(connection -> {
                for (ArtifactDefinition artifactDefinition : this.artifactDefinitionDao.findAll(firstResult, 100)) {
                    if (!this.recalculateOid((EntityWithOid)artifactDefinition, newServerKey)) continue;
                    this.artifactDefinitionDao.save((BambooObject)artifactDefinition);
                }
            });
            i += 100;
        }
    }

    private void recalculateCredentialsOid(int newServerKey) throws Exception {
        long numberOfCredentials = this.credentialsDao.countAll(MutableCredentialsData.class);
        int i = 0;
        while ((long)i < numberOfCredentials) {
            int firstResult = i;
            this.bambooTransactionHibernateTemplate.doWork(connection -> {
                for (MutableCredentialsData credential : this.credentialsDao.findAll(firstResult, 100)) {
                    if (!this.recalculateOid((EntityWithOid)credential, newServerKey)) continue;
                    this.credentialsDao.save((BambooObject)credential);
                }
            });
            i += 100;
        }
    }

    private void recalculateDeploymentProjectsOid(int newServerKey) throws Exception {
        this.bambooTransactionHibernateTemplate.doWork(connection -> {
            for (MutableDeploymentProject deploymentProject : this.deploymentProjectDao.getAllDeploymentProjects()) {
                if (!this.recalculateOid((EntityWithOid)deploymentProject, newServerKey)) continue;
                this.deploymentProjectDao.save(deploymentProject);
            }
        });
    }
}

