/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_14;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.google.common.collect.ImmutableSet;
import java.sql.Connection;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask51401UpperCaseDbTableNames
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask51401UpperCaseDbTableNames.class);
    final Set<String> lowerCaseTables = ImmutableSet.of((Object)"groups", (Object)"password_reset_token", (Object)"users", (Object)"external_entities", (Object)"external_members", (Object)"local_members", (Object[])new String[]{"variablesToAutoIncrement"});
    @Autowired
    private DbmsBean dbmsBean;

    public UpgradeTask51401UpperCaseDbTableNames() {
        super("51401", "Change table names to uppercase on MS SQL and MySQL");
    }

    public void doUpgrade() throws Exception {
        if (!this.dbmsBean.isMsSqlServer() && !this.dbmsBean.isMySql()) {
            return;
        }
        try (Connection connection = this.getDatabaseConnection();){
            for (String tableName : this.lowerCaseTables) {
                this.dbmsBean.changeTableNameToUpperCase(connection, tableName);
            }
        }
    }
}

