/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_14;

import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataImpl;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfiguration;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfigurationXmlConverter;
import com.atlassian.bamboo.vcs.configuration.service.VcsRepositoryConfigurationService;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractConvertRepositoryTypesUpgrade
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(AbstractConvertRepositoryTypesUpgrade.class);
    private static final int PAGE_SIZE = 50;
    @Autowired
    private RepositoryDefinitionDao repositoryDefinitionDao;
    @Autowired
    private BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate;
    @Autowired
    private RawRepositoryConfigurationXmlConverter rawRepositoryConfigurationXmlConverter;
    @Autowired
    private VcsRepositoryConfigurationService vcsRepositoryConfigurationService;

    public AbstractConvertRepositoryTypesUpgrade(@NotNull String shortDescription) {
        super(shortDescription);
    }

    public AbstractConvertRepositoryTypesUpgrade(@NotNull String buildNumber, @NotNull String shortDescription) {
        super(buildNumber, shortDescription);
    }

    protected void upgradeRepositories() throws Exception {
        long numberOfRepositories = this.repositoryDefinitionDao.countAllByParent(null);
        int i = 0;
        while ((long)i < numberOfRepositories) {
            int firstResult = i;
            this.bambooTransactionHibernateTemplate.doWork(connection -> {
                Collection repositories = this.repositoryDefinitionDao.findAllByParent(null, firstResult, 50);
                this.convertXmlData(repositories, null);
            });
            i += 50;
        }
    }

    private void convertXmlData(Collection<? extends RepositoryDataEntity> repositories, PartialVcsRepositoryData convertedParent) {
        for (RepositoryDataEntity repositoryDataEntity : repositories) {
            RawRepositoryConfiguration rawConfiguration;
            try {
                rawConfiguration = this.rawRepositoryConfigurationXmlConverter.fromEntity(repositoryDataEntity);
            }
            catch (Exception e) {
                log.warn((Object)("error loading repository " + repositoryDataEntity.getId() + ". Skipping."));
                continue;
            }
            PartialVcsRepositoryDataImpl unconverted = new PartialVcsRepositoryDataImpl(repositoryDataEntity, rawConfiguration, convertedParent == null ? null : convertedParent.getCompleteData());
            PartialVcsRepositoryData converted = this.vcsRepositoryConfigurationService.convertToNewRepositoryConfiguration((PartialVcsRepositoryData)unconverted);
            if (converted != unconverted) {
                repositoryDataEntity.setXmlData(this.rawRepositoryConfigurationXmlConverter.asXml(converted));
                repositoryDataEntity.setPluginKey(converted.getPluginKey());
                this.repositoryDefinitionDao.save((BambooObject)repositoryDataEntity);
            }
            long numberOfRepositories = this.repositoryDefinitionDao.countAllByParent(Long.valueOf(repositoryDataEntity.getId()));
            int i = 0;
            while ((long)i < numberOfRepositories) {
                int firstResult = i;
                this.bambooTransactionHibernateTemplate.doWork(connection -> {
                    Collection children = this.repositoryDefinitionDao.findAllByParent(Long.valueOf(entity.getId()), firstResult, 50);
                    this.convertXmlData(children, converted);
                });
                i += 50;
            }
        }
    }
}

