/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_13;

import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.setup.BambooApplicationConfig;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.upgrade.utils.ArtifactDefinitionUpgrader;
import com.google.common.collect.ImmutableSet;
import io.atlassian.util.concurrent.Lazy;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask51315ConvertPathsInArtifactDefinitions
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask51315ConvertPathsInArtifactDefinitions.class);
    public static final String PROPERTY_FORCE_UPGRADE = "UpgradeTask51315ConvertPathsInArtifactDefinitions";
    private static final Pattern SLASHES = Pattern.compile("^/+");
    private static final Set<String> BROKEN_VERSIONS = ImmutableSet.of((Object)"51314", (Object)"51217");
    @Autowired
    private ArtifactDefinitionUpgrader artifactDefinitionUpgrader;
    @Autowired
    private BambooApplicationConfig applicationConfig;
    private final Supplier<Boolean> skipUpgradeTask = Lazy.supplier(() -> {
        boolean skipUpgradeTask;
        String startupBuildNumber = this.applicationConfig.getStartupBuildNumber();
        if (startupBuildNumber == null) {
            log.info((Object)"No startup build number, running upgrade task");
            return false;
        }
        boolean upgradeFromBrokenVersion = BROKEN_VERSIONS.contains(startupBuildNumber);
        boolean forceUpgradeTaskExecution = System.getProperty(PROPERTY_FORCE_UPGRADE) != null;
        boolean bl = skipUpgradeTask = upgradeFromBrokenVersion && !forceUpgradeTaskExecution;
        if (skipUpgradeTask) {
            log.info((Object)"Skipping upgrade task execution");
        }
        return skipUpgradeTask;
    });

    public UpgradeTask51315ConvertPathsInArtifactDefinitions() {
        super("Convert Unix absolute paths to relative in artifact definition location");
    }

    public void doUpgrade() throws Exception {
        if (this.skipUpgradeTask.get().booleanValue()) {
            return;
        }
        this.artifactDefinitionUpgrader.upgrade(this::modifyLocation);
    }

    private Optional<ArtifactDefinition> modifyLocation(ArtifactDefinition artifactDefinition) {
        String newArtifactLocation;
        Optional<ArtifactDefinition> result = Optional.empty();
        String artifactLocation = artifactDefinition.getLocation();
        if (artifactLocation != null && !(newArtifactLocation = SLASHES.matcher(artifactLocation).replaceFirst("")).equals(artifactLocation)) {
            artifactDefinition.setLocation(newArtifactLocation);
            result = Optional.of(artifactDefinition);
        }
        return result;
    }
}

