/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_13;

import com.atlassian.bamboo.setup.BambooApplicationConfig;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.upgrade.tasks.AbstractTaskConfigurationUpgradeTask;
import io.atlassian.util.concurrent.Lazy;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask51314ConvertPathsInDownloadTasks
extends AbstractTaskConfigurationUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask51314ConvertPathsInDownloadTasks.class);
    private static final Pattern SLASHES = Pattern.compile("^/+");
    @Autowired
    private BambooApplicationConfig applicationConfig;
    private final Supplier<Boolean> skipUpgradeTask = Lazy.supplier(() -> {
        boolean skipUpgradeTask;
        String startupBuildNumber = this.applicationConfig.getStartupBuildNumber();
        if (startupBuildNumber == null) {
            log.info((Object)"No startup build number, running path conversion");
            return false;
        }
        boolean upgradeFromBrokenVersion = startupBuildNumber.startsWith("512");
        boolean forceUpgradeTaskExecution = System.getProperty("UpgradeTask51314ConvertPathsInDownloadTasks") != null;
        boolean bl = skipUpgradeTask = upgradeFromBrokenVersion && !forceUpgradeTaskExecution;
        if (skipUpgradeTask) {
            log.info((Object)"Skipping upgrade task execution");
        }
        return skipUpgradeTask;
    });

    public UpgradeTask51314ConvertPathsInDownloadTasks() {
        super("Convert Unix absolute paths to relative in download tasks");
    }

    @Override
    protected boolean updateTaskDefinition(TaskDefinition taskDefinition) {
        if (this.skipUpgradeTask.get().booleanValue()) {
            return false;
        }
        if (!taskDefinition.getPluginKey().equals("com.atlassian.bamboo.plugins.bamboo-artifact-downloader-plugin:artifactdownloadertask")) {
            return false;
        }
        Map configuration = taskDefinition.getConfiguration();
        Set pathKeys = configuration.keySet().stream().filter(k -> k.startsWith("localPath")).collect(Collectors.toSet());
        boolean somethingChanged = false;
        for (String pathKey : pathKeys) {
            String pathValue = (String)configuration.get(pathKey);
            String newPathValue = SLASHES.matcher(pathValue).replaceFirst("");
            if (newPathValue.equals(pathValue)) continue;
            configuration.put(pathKey, newPathValue);
            somethingChanged = true;
        }
        return somethingChanged;
    }
}

