/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_13;

import com.atlassian.bamboo.configuration.ConfigurationMapImpl;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.upgrade.tasks.AbstractTaskConfigurationUpgradeTask;
import org.apache.commons.lang3.StringUtils;

public class UpgradeTask51313MigrateLegacyScriptTasks
extends AbstractTaskConfigurationUpgradeTask {
    private static final String CFG_RUN_WITH_POWERSHELL = "runWithPowershell";
    private static final String CFG_INTERPRETER = "interpreter";
    private static final String KEY_POWERSHELL = "POWERSHELL";
    private static final String KEY_LEGACY_SH_BAT = "LEGACY_SH_BAT";

    public UpgradeTask51313MigrateLegacyScriptTasks() {
        super("Migrate legacy script tasks in plans");
    }

    @Override
    protected boolean updateTaskDefinition(TaskDefinition taskDefinition) {
        if (!UpgradeTask51313MigrateLegacyScriptTasks.isLegacyScriptTask(taskDefinition)) {
            return false;
        }
        UpgradeTask51313MigrateLegacyScriptTasks.modifyScriptTaskDefinition(taskDefinition);
        return true;
    }

    private static void modifyScriptTaskDefinition(TaskDefinition taskDefinition) {
        ConfigurationMapImpl taskConfiguration = new ConfigurationMapImpl(taskDefinition.getConfiguration());
        String interpreter = taskConfiguration.getAsBoolean(CFG_RUN_WITH_POWERSHELL) ? KEY_POWERSHELL : KEY_LEGACY_SH_BAT;
        taskConfiguration.put((Object)CFG_INTERPRETER, (Object)interpreter);
        taskConfiguration.remove((Object)CFG_RUN_WITH_POWERSHELL);
    }

    private static boolean isLegacyScriptTask(TaskDefinition taskDefinition) {
        if (taskDefinition.getPluginKey().equals("com.atlassian.bamboo.plugins.scripttask:task.builder.script")) {
            ConfigurationMapImpl taskConfiguration = new ConfigurationMapImpl(taskDefinition.getConfiguration());
            return StringUtils.isEmpty((CharSequence)((CharSequence)taskConfiguration.get((Object)CFG_INTERPRETER)));
        }
        return false;
    }
}

