/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_13;

import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import com.atlassian.bamboo.repository.RepositoryDefinitionHibernateDao;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfigurationXmlConverterImpl;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask51311RefactorBitbucketRepositoriesConfiguration
extends AbstractUpgradeTask {
    private static final int PAGE_SIZE = 100;
    private static final String BB_REPOSITORY_PLUGIN_KEY = "com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-bitbucket:bb";
    private static final String BB_CFG_ACCESS_LEVEL = "repository.bitbucket.accessLevel";
    private static final String BB_CFG_AUTHENTICATION_TYPE = "repository.bitbucket.authenticationType";
    private static final String BB_CFG_OWNER = "repository.bitbucket.owner";
    private static final String BB_CFG_USERNAME = "repository.bitbucket.username";
    private static final String BB_CFG_PASSWORD = "repository.bitbucket.password";
    private static final String BB_CFG_PASSWORD_CREDENTIALS_SOURCE = "repository.bitbucket.passwordCredentialsSource";
    private static final String BB_ACCESS_LEVEL_PUBLIC = "PUBLIC";
    private static final String BB_ACCESS_LEVEL_PRIVATE = "PRIVATE";
    private static final String BB_PASSWORD_CREDENTIALS_SOURCE_CUSTOM = "CUSTOM";
    private static final String BB_AUTHENTICATION_TYPE_PASSWORD = "PASSWORD";
    private static final String BB_AUTHENTICATION_TYPE_NONE = "NONE";
    @Autowired
    private BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate;
    @Autowired
    private RepositoryDefinitionDao repositoryDefinitionDao;

    public UpgradeTask51311RefactorBitbucketRepositoriesConfiguration() {
        super("Refactor Bitbucket Cloud repositories configuration");
    }

    public void doUpgrade() throws Exception {
        long numberOfRepositories = ((RepositoryDefinitionHibernateDao)this.repositoryDefinitionDao).countRepositoriesByPluginKey(BB_REPOSITORY_PLUGIN_KEY);
        int i = 0;
        while ((long)i < numberOfRepositories) {
            int firstResult = i;
            this.bambooTransactionHibernateTemplate.doWork(connection -> ((RepositoryDefinitionHibernateDao)this.repositoryDefinitionDao).findRepositoriesByPluginKey(BB_REPOSITORY_PLUGIN_KEY, firstResult, 100).forEach(this::upgradeBitbucketRepository));
            i += 100;
        }
    }

    @VisibleForTesting
    void upgradeBitbucketRepository(@NotNull RepositoryDataEntity repository) {
        if (RawRepositoryConfigurationXmlConverterImpl.isEntityIn514Format((RepositoryDataEntity)repository)) {
            return;
        }
        BuildConfiguration config = new BuildConfiguration(repository.getXmlData());
        boolean isAccessLevelPrivate = this.isAccessLevelPrivate((HierarchicalConfiguration)config);
        boolean updated = false;
        if (!config.containsKey(BB_CFG_ACCESS_LEVEL)) {
            String accessLevel = isAccessLevelPrivate ? BB_ACCESS_LEVEL_PRIVATE : BB_ACCESS_LEVEL_PUBLIC;
            config.setProperty(BB_CFG_ACCESS_LEVEL, (Object)accessLevel);
            updated = true;
        }
        if (!config.containsKey(BB_CFG_AUTHENTICATION_TYPE)) {
            String authenticationType = isAccessLevelPrivate ? BB_AUTHENTICATION_TYPE_PASSWORD : BB_AUTHENTICATION_TYPE_NONE;
            config.setProperty(BB_CFG_AUTHENTICATION_TYPE, (Object)authenticationType);
            updated = true;
        }
        if (isAccessLevelPrivate && !config.containsKey(BB_CFG_PASSWORD_CREDENTIALS_SOURCE)) {
            config.setProperty(BB_CFG_PASSWORD_CREDENTIALS_SOURCE, (Object)BB_PASSWORD_CREDENTIALS_SOURCE_CUSTOM);
            updated = true;
        }
        if (!isAccessLevelPrivate && !config.containsKey(BB_CFG_OWNER)) {
            config.setProperty(BB_CFG_OWNER, (Object)config.getString(BB_CFG_USERNAME, ""));
            config.clearProperty(BB_CFG_USERNAME);
            updated = true;
        }
        if (updated) {
            repository.setXmlData(config.asXml());
            this.repositoryDefinitionDao.save((BambooObject)repository);
        }
    }

    private boolean isAccessLevelPrivate(HierarchicalConfiguration config) {
        return config.containsKey(BB_CFG_ACCESS_LEVEL) ? config.getString(BB_CFG_ACCESS_LEVEL).equals(BB_ACCESS_LEVEL_PRIVATE) : StringUtils.isNotEmpty((CharSequence)config.getString(BB_CFG_PASSWORD, null));
    }
}

