/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_13;

import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import com.atlassian.bamboo.repository.RepositoryDefinitionHibernateDao;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfigurationXmlConverterImpl;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask51308RefactorHgRepositoriesConfiguration
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask51308RefactorHgRepositoriesConfiguration.class);
    private static final int PAGE_SIZE = 100;
    private static final String REPOSITORY_PLUGIN_KEY = "com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-mercurial:hg";
    private static final String AUTH_PASSWORD = "PASSWORD";
    private static final String AUTH_SSH_PROXY = "SSH_PROXY";
    private static final String AUTH_KEYFILE = "KEYFILE";
    private static final String AUTH_BYPASS = "BYPASS";
    private static final String AUTH_SHARED_CREDENTIALS = "SHARED_CREDENTIALS";
    @Autowired
    private BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate;
    @Autowired
    private RepositoryDefinitionDao repositoryDefinitionDao;

    public UpgradeTask51308RefactorHgRepositoriesConfiguration() {
        super("Refactor Hg repositories configuration");
    }

    public void doUpgrade() throws Exception {
        long numberOfRepositories = ((RepositoryDefinitionHibernateDao)this.repositoryDefinitionDao).countRepositoriesByPluginKey(REPOSITORY_PLUGIN_KEY);
        int i = 0;
        while ((long)i < numberOfRepositories) {
            int firstResult = i;
            this.bambooTransactionHibernateTemplate.doWork(connection -> ((RepositoryDefinitionHibernateDao)this.repositoryDefinitionDao).findRepositoriesByPluginKey(REPOSITORY_PLUGIN_KEY, firstResult, 100).forEach(this::upgradeRepository));
            i += 100;
        }
    }

    @VisibleForTesting
    void upgradeRepository(@NotNull RepositoryDataEntity repository) {
        if (RawRepositoryConfigurationXmlConverterImpl.isEntityIn514Format((RepositoryDataEntity)repository)) {
            return;
        }
        BuildConfiguration config = new BuildConfiguration(repository.getXmlData());
        boolean configUpdated = false;
        String authenticationType = config.getString("repository.hg.authentication");
        if (AUTH_PASSWORD.equals(authenticationType)) {
            if (!config.containsKey("repository.hg.password.source")) {
                config.setProperty("repository.hg.password.source", (Object)"CUSTOM");
                this.moveKey(config, "repository.hg.password.username", "repository.hg.username");
                this.moveKey(config, "repository.hg.password.password", "repository.hg.password");
                configUpdated = true;
            }
        } else if (AUTH_SSH_PROXY.equals(authenticationType)) {
            if (!config.containsKey("repository.hg.ssh_proxy.source")) {
                config.setProperty("repository.hg.ssh_proxy.source", (Object)"CUSTOM");
                this.moveKey(config, "repository.hg.ssh_proxy.privateKey", "repository.hg.ssh.keyFromFile");
                this.moveKey(config, "repository.hg.ssh_proxy.passphrase", "repository.hg.ssh.passphrase");
                this.mergeUsernameWithUrl(repository, config);
                configUpdated = true;
            }
        } else if (AUTH_KEYFILE.equals(authenticationType)) {
            if (!config.containsKey("repository.hg.keyfile.privateKey")) {
                this.moveKey(config, "repository.hg.keyfile.privateKey", "repository.hg.ssh.keyFromFile");
                this.mergeUsernameWithUrl(repository, config);
                configUpdated = true;
            }
        } else if (AUTH_BYPASS.equals(authenticationType)) {
            configUpdated = this.mergeUsernameWithUrl(repository, config);
        } else if (AUTH_SHARED_CREDENTIALS.equals(authenticationType)) {
            config.setProperty("repository.hg.authentication", (Object)AUTH_SSH_PROXY);
            config.setProperty("repository.hg.ssh_proxy.source", (Object)AUTH_SHARED_CREDENTIALS);
            this.moveKey(config, "repository.hg.ssh_proxy.sharedCredentials", "repository.hg.sharedCredentials");
            this.mergeUsernameWithUrl(repository, config);
            configUpdated = true;
        }
        if (configUpdated) {
            repository.setXmlData(config.asXml());
            this.repositoryDefinitionDao.save((BambooObject)repository);
        }
    }

    private void moveKey(BuildConfiguration configuration, String newKey, String oldKey) {
        configuration.setProperty(newKey, (Object)configuration.getString(oldKey));
        configuration.clearProperty(oldKey);
    }

    private boolean mergeUsernameWithUrl(RepositoryDataEntity repository, BuildConfiguration configuration) {
        if (configuration.containsKey("repository.hg.username")) {
            if (StringUtils.isNotBlank((CharSequence)configuration.getString("repository.hg.username"))) {
                String username = configuration.getString("repository.hg.username");
                String url = configuration.getString("repository.hg.repositoryUrl");
                try {
                    configuration.setProperty("repository.hg.repositoryUrl", (Object)new URIBuilder(url).setUserInfo(username).build().toString());
                }
                catch (Exception e) {
                    log.error((Object)String.format("problem while converting repository %d: unable to merge username '%s' with url '%s'", repository.getId(), username, url));
                }
            }
            configuration.clearProperty("repository.hg.username");
            return true;
        }
        return false;
    }

    static interface Cfg513 {
        public static final String CRED_CUSTOM = "CUSTOM";
        public static final String CRED_SHARED_CREDENTIALS = "SHARED_CREDENTIALS";

        public static interface KeyFile {
            public static final String PRIVATE_KEY = "repository.hg.keyfile.privateKey";
        }

        public static interface SshProxy {
            public static final String CREDENTIALS_SOURCE = "repository.hg.ssh_proxy.source";
            public static final String PRIVATE_KEY = "repository.hg.ssh_proxy.privateKey";
            public static final String PASSPHRASE = "repository.hg.ssh_proxy.passphrase";
            public static final String SHARED_CREDENTIALS = "repository.hg.ssh_proxy.sharedCredentials";
        }

        public static interface UsernamePassword {
            public static final String CREDENTIALS_SOURCE = "repository.hg.password.source";
            public static final String USERNAME = "repository.hg.password.username";
            public static final String PASSWORD = "repository.hg.password.password";
        }
    }

    static interface Cfg512 {
        public static final String USERNAME = "repository.hg.username";
        public static final String PASSWORD = "repository.hg.password";
        public static final String SSH_KEY = "repository.hg.ssh.keyFromFile";
        public static final String PASSPHRASE = "repository.hg.ssh.passphrase";
        public static final String SHARED_CREDENTIALS = "repository.hg.sharedCredentials";
    }

    static interface Cfg {
        public static final String URL = "repository.hg.repositoryUrl";
        public static final String AUTHENTICATION = "repository.hg.authentication";
    }
}

