/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_13;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.upgrade.AdministrationConfigurationUpgrader;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class UpgradeTask51306UpdateSerializationSecurityConfig
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask51306UpdateSerializationSecurityConfig.class);
    private static final String DEFAULT_VALUE_BEFORE_UPDATE = "STRICT_BLACKLIST";
    private static final String DEFAULT_VALUE_AFTER_UPDATE = "WHITELIST";

    protected UpgradeTask51306UpdateSerializationSecurityConfig() {
        super("Set 'WHITELIST' method for xStream serialization security configuration value in administration.xml");
    }

    public void doUpgrade() throws Exception {
        AdministrationConfigurationUpgrader adminConfigUpgrader = new AdministrationConfigurationUpgrader(this.bootstrapManager);
        Element xStreamMethod = adminConfigUpgrader.getElement("//serializationSecurityConfig/xStreamMethod");
        boolean requiresSave = false;
        if (xStreamMethod != null) {
            if (DEFAULT_VALUE_BEFORE_UPDATE.equals(xStreamMethod.getText())) {
                xStreamMethod.setText(DEFAULT_VALUE_AFTER_UPDATE);
                log.info((Object)"set 'WHITELIST' for xStreamMethod");
                requiresSave = true;
            } else {
                log.info((Object)("serializationSecurityConfig setting for xStreamMethod is non-default '" + xStreamMethod.getText() + "', skip update and leave it as administrator choice"));
            }
        }
        if (requiresSave) {
            log.info((Object)"saving administration.xml");
            adminConfigUpgrader.save();
        }
    }
}

