/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_13;

import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import com.atlassian.bamboo.repository.RepositoryDefinitionHibernateDao;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfigurationXmlConverterImpl;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask51305RefactorGitRepositoriesConfiguration
extends AbstractUpgradeTask {
    private static final int PAGE_SIZE = 100;
    private static final String GIT_REPOSITORY_PLUGIN_KEY = "com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:git";
    private static final String GIT_CFG_AUTH_TYPE = "repository.git.authenticationType";
    private static final String GIT_CFG_SSH_CREDENTIALS_SOURCE = "repository.git.sshCredentialsSource";
    private static final String GIT_CFG_PASSWORD_CREDENTIALS_SOURCE = "repository.git.passwordCredentialsSource";
    private static final String GIT_CFG_SHARED_CREDENTIALS = "repository.git.sharedCredentials";
    private static final String GIT_CFG_SHARED_CREDENTIALS_WITH_TYPO = "repository.git.sharedCrendentials";
    private static final String GIT_AUTH_TYPE_SHARED_CREDENTIALS = "SHARED_CREDENTIALS";
    private static final String GIT_AUTH_TYPE_SSH = "SSH_KEYPAIR";
    private static final String GIT_AUTH_TYPE_PASSWORD = "PASSWORD";
    private static final String GIT_SSH_CREDENTIALS_SOURCE_SHARED_CREDENTIALS = "SHARED_CREDENTIALS";
    private static final String GIT_SSH_CREDENTIALS_SOURCE_CUSTOM = "CUSTOM";
    private static final String GIT_PASSWORD_CREDENTIALS_SOURCE_CUSTOM = "CUSTOM";
    @Autowired
    private BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate;
    @Autowired
    private RepositoryDefinitionDao repositoryDefinitionDao;

    public UpgradeTask51305RefactorGitRepositoriesConfiguration() {
        super("Refactor Git repositories configuration");
    }

    public void doUpgrade() throws Exception {
        long numberOfRepositories = ((RepositoryDefinitionHibernateDao)this.repositoryDefinitionDao).countRepositoriesByPluginKey(GIT_REPOSITORY_PLUGIN_KEY);
        int i = 0;
        while ((long)i < numberOfRepositories) {
            int firstResult = i;
            this.bambooTransactionHibernateTemplate.doWork(connection -> ((RepositoryDefinitionHibernateDao)this.repositoryDefinitionDao).findRepositoriesByPluginKey(GIT_REPOSITORY_PLUGIN_KEY, firstResult, 100).forEach(this::upgradeGitRepository));
            i += 100;
        }
    }

    @VisibleForTesting
    void upgradeGitRepository(@NotNull RepositoryDataEntity repository) {
        String authType;
        if (RawRepositoryConfigurationXmlConverterImpl.isEntityIn514Format((RepositoryDataEntity)repository)) {
            return;
        }
        BuildConfiguration config = new BuildConfiguration(repository.getXmlData());
        boolean updated = false;
        if (config.getLong(GIT_CFG_SHARED_CREDENTIALS_WITH_TYPO, null) != null) {
            config.setProperty(GIT_CFG_SHARED_CREDENTIALS, (Object)config.getLong(GIT_CFG_SHARED_CREDENTIALS_WITH_TYPO));
            config.clearProperty(GIT_CFG_SHARED_CREDENTIALS_WITH_TYPO);
            updated = true;
        }
        if ("SHARED_CREDENTIALS".equals(authType = config.getString(GIT_CFG_AUTH_TYPE, null))) {
            config.setProperty(GIT_CFG_AUTH_TYPE, (Object)GIT_AUTH_TYPE_SSH);
            config.setProperty(GIT_CFG_SSH_CREDENTIALS_SOURCE, (Object)"SHARED_CREDENTIALS");
            updated = true;
        } else if (GIT_AUTH_TYPE_SSH.equals(authType)) {
            if (StringUtils.isEmpty((CharSequence)config.getString(GIT_CFG_SSH_CREDENTIALS_SOURCE, null))) {
                config.setProperty(GIT_CFG_SSH_CREDENTIALS_SOURCE, (Object)"CUSTOM");
                updated = true;
            }
        } else if (GIT_AUTH_TYPE_PASSWORD.equals(authType) && StringUtils.isEmpty((CharSequence)config.getString(GIT_CFG_PASSWORD_CREDENTIALS_SOURCE, null))) {
            config.setProperty(GIT_CFG_PASSWORD_CREDENTIALS_SOURCE, (Object)"CUSTOM");
            updated = true;
        }
        if (updated) {
            repository.setXmlData(config.asXml());
            this.repositoryDefinitionDao.save((BambooObject)repository);
        }
    }
}

