/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_13;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.google.common.collect.ImmutableSet;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask51301UpperCaseDbColumnNames
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask51301UpperCaseDbColumnNames.class);
    @Autowired
    private DbmsBean dbmsBean;

    public UpgradeTask51301UpperCaseDbColumnNames() {
        super("51301", "Change column names to uppercase on MS SQL");
    }

    public void doUpgrade() throws Exception {
        if (!this.dbmsBean.isMsSqlServer()) {
            return;
        }
        HashMap<String, ImmutableSet> lowerCaseColumns = new HashMap<String, ImmutableSet>();
        lowerCaseColumns.put("groups", ImmutableSet.of((Object)"id", (Object)"groupname"));
        lowerCaseColumns.put("OS_PROPERTYENTRY", ImmutableSet.of((Object)"entity_name", (Object)"entity_id", (Object)"entity_key", (Object)"key_type", (Object)"boolean_val", (Object)"double_val", (Object[])new String[]{"string_val", "text_val", "long_val", "int_val", "date_val"}));
        lowerCaseColumns.put("password_reset_token", ImmutableSet.of((Object)"id", (Object)"username", (Object)"token", (Object)"token_created"));
        lowerCaseColumns.put("AUTH_ATTEMPT_INFO", ImmutableSet.of((Object)"id"));
        lowerCaseColumns.put("users", ImmutableSet.of((Object)"id", (Object)"name", (Object)"password", (Object)"email", (Object)"created", (Object)"fullname", (Object[])new String[0]));
        lowerCaseColumns.put("SCRIPT", ImmutableSet.of((Object)"body"));
        lowerCaseColumns.put("external_entities", ImmutableSet.of((Object)"id", (Object)"name", (Object)"type"));
        lowerCaseColumns.put("TRUSTED_KEY", ImmutableSet.of((Object)"id"));
        lowerCaseColumns.put("REMEMBERME_TOKEN", ImmutableSet.of((Object)"id"));
        lowerCaseColumns.put("external_members", ImmutableSet.of((Object)"extentityid", (Object)"groupid"));
        lowerCaseColumns.put("local_members", ImmutableSet.of((Object)"userid", (Object)"groupid"));
        try (Connection connection = this.getDatabaseConnection();){
            for (String tableName : lowerCaseColumns.keySet()) {
                if (this.dbmsBean.isTablePresent(connection, tableName)) {
                    for (String columnName : (Set)lowerCaseColumns.get(tableName)) {
                        this.dbmsBean.renameColumn(connection, tableName, columnName, columnName.toUpperCase(Locale.ENGLISH));
                    }
                    continue;
                }
                log.info((Object)("Table " + tableName + " not found. Probably migrating from older Bamboo version."));
            }
        }
    }
}

