/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_12;

import com.atlassian.bamboo.agent.elastic.server.ElasticConfiguration;
import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.build.artifact.S3ArtifactHandlerConfigurator;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.ConfigurationMapImpl;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask51208FixS3ArtifactHandlerForServer
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask51208FixS3ArtifactHandlerForServer.class);
    private static final String PREFIX = "custom.artifactHandlers.comAtlassianBambooPluginArtifactHandlerRemote:S3ArtifactHandler:";
    @VisibleForTesting
    static final String S3_ENABLED_FOR_NON_SHARED = "custom.artifactHandlers.comAtlassianBambooPluginArtifactHandlerRemote:S3ArtifactHandler:enabledForNonShared";
    @VisibleForTesting
    static final String S3_ENABLED_FOR_SHARED = "custom.artifactHandlers.comAtlassianBambooPluginArtifactHandlerRemote:S3ArtifactHandler:enabledForShared";
    @VisibleForTesting
    static final String AWS_ACCESS_KEY = "custom.artifactHandlers.comAtlassianBambooPluginArtifactHandlerRemote:S3ArtifactHandler:accessKeyId";
    @VisibleForTesting
    static final String AWS_SECRET_KEY = "custom.artifactHandlers.comAtlassianBambooPluginArtifactHandlerRemote:S3ArtifactHandler:secretAccessKey";
    @VisibleForTesting
    static final String CONF_SOURCE_KEY = "custom.artifactHandlers.comAtlassianBambooPluginArtifactHandlerRemote:S3ArtifactHandler:credentialsSource";
    @VisibleForTesting
    static final BandanaContext BANDANA_CONTEXT = PlanAwareBandanaContext.GLOBAL_CONTEXT;
    @VisibleForTesting
    static final String BANDANA_KEY = "artifactHandlersConfiguration";
    @Autowired
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    @Autowired
    private BandanaManager bandanaManager;

    protected UpgradeTask51208FixS3ArtifactHandlerForServer() {
        super("Fix server artifact handlers configuration");
    }

    public void doUpgrade() throws Exception {
        HashMap<String, String> configuration = (HashMap<String, String>)this.bandanaManager.getValue(BANDANA_CONTEXT, BANDANA_KEY);
        if (configuration == null) {
            configuration = new HashMap<String, String>();
        }
        ConfigurationMapImpl configurationMap = new ConfigurationMapImpl(configuration);
        boolean configurationModified = false;
        if (configurationMap.getAsBoolean(S3_ENABLED_FOR_NON_SHARED) || configurationMap.getAsBoolean(S3_ENABLED_FOR_SHARED)) {
            String currentSource = (String)configuration.get(CONF_SOURCE_KEY);
            if (!S3ArtifactHandlerConfigurator.AwsCredentialsSource.EC2.getValue().equals(currentSource) && (StringUtils.isBlank((CharSequence)((CharSequence)configuration.get(AWS_ACCESS_KEY))) || StringUtils.isBlank((CharSequence)((CharSequence)configuration.get(AWS_SECRET_KEY))))) {
                ElasticConfiguration ec2Config = this.administrationConfigurationAccessor.getAdministrationConfiguration().getElasticConfig();
                if (ec2Config != null && ec2Config.isEnabled()) {
                    configuration.put(CONF_SOURCE_KEY, S3ArtifactHandlerConfigurator.AwsCredentialsSource.EC2.getValue());
                    configurationModified = true;
                } else {
                    log.warn((Object)"EC2 not configured and credentials undefined. EC2 artifact handler will not be functional");
                }
            }
            if (!configurationModified && StringUtils.isBlank((CharSequence)currentSource)) {
                configuration.put(CONF_SOURCE_KEY, S3ArtifactHandlerConfigurator.AwsCredentialsSource.CUSTOM.getValue());
                configurationModified = true;
            }
        }
        if (configurationModified) {
            this.bandanaManager.setValue(BANDANA_CONTEXT, BANDANA_KEY, new HashMap(configuration));
        }
    }
}

