/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_12;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.bamboo.utils.db.JdbcUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask51207RepairStagesResultsListPosition
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask51207RepairStagesResultsListPosition.class);
    private static final String RESULTS_WITH_STAGES_HOLES = "select distinct S1.CHAINRESULT_ID from CHAIN_STAGE_RESULT S1 left join CHAIN_STAGE_RESULT S2 on (S1.CHAINRESULT_ID = S2.CHAINRESULT_ID and S1.LIST_POSITION = S2.LIST_POSITION + 1) where S1.LIST_POSITION != 0 and S2.STAGERESULT_ID is null";
    private static final String RESULTS_WITH_STAGES_HOLES_HSQL = "select distinct S1.CHAINRESULT_ID from CHAIN_STAGE_RESULT S1 where S1.LIST_POSITION != 0 and not exists ( select S2.CHAINRESULT_ID from CHAIN_STAGE_RESULT S2 where S1.CHAINRESULT_ID = S2.CHAINRESULT_ID and S1.LIST_POSITION = S2.LIST_POSITION + 1)";
    private static final String RESULTS_WITH_STAGES_DUPLICATES = "select distinct CHAINRESULT_ID from CHAIN_STAGE_RESULT group by CHAINRESULT_ID,LIST_POSITION having count(CHAINRESULT_ID)>1";
    private static final String STAGES_POSITIONS_IN_RESULT = "select STAGERESULT_ID, LIST_POSITION from CHAIN_STAGE_RESULT where CHAINRESULT_ID = ? order by LIST_POSITION, STAGERESULT_ID";
    private static final String UPDATE_RESULT_STAGE_POSITION = "update CHAIN_STAGE_RESULT set LIST_POSITION = ? where STAGERESULT_ID = ?";
    @Autowired
    private DbmsBean dbmsBean;

    public UpgradeTask51207RepairStagesResultsListPosition() {
        super("Repair Stages Results List Position");
    }

    public void doUpgrade() throws Exception {
        this.withDatabaseConnection(connection -> {
            HashSet chainsResultsWithStagesToFix = new HashSet();
            String resultsWithStagesHoles = this.dbmsBean.isHsqldb() ? RESULTS_WITH_STAGES_HOLES_HSQL : RESULTS_WITH_STAGES_HOLES;
            chainsResultsWithStagesToFix.addAll(JdbcUtils.getListOfLong((Connection)connection, (String)resultsWithStagesHoles));
            chainsResultsWithStagesToFix.addAll(JdbcUtils.getListOfLong((Connection)connection, (String)RESULTS_WITH_STAGES_DUPLICATES));
            log.info((Object)String.format("Number of results that have stages positions to fix: %d. Id of results: %s", chainsResultsWithStagesToFix.size(), chainsResultsWithStagesToFix));
            Iterator iterator = chainsResultsWithStagesToFix.iterator();
            while (iterator.hasNext()) {
                long chainResultId = (Long)iterator.next();
                this.fixResultStages(connection, chainResultId);
            }
        });
    }

    private void fixResultStages(@NotNull Connection connection, long chainResultId) throws SQLException {
        Throwable throwable;
        ArrayList<Pair> stagesResultsToFix = new ArrayList<Pair>();
        try (PreparedStatement statement = connection.prepareStatement(STAGES_POSITIONS_IN_RESULT);){
            statement.setLong(1, chainResultId);
            throwable = null;
            try (ResultSet resultSet = statement.executeQuery();){
                int currentPosition = 0;
                while (resultSet.next()) {
                    int position = resultSet.getInt(2);
                    if (position != currentPosition) {
                        long stageResultId = resultSet.getLong(1);
                        stagesResultsToFix.add(Pair.make((Object)stageResultId, (Object)currentPosition));
                    }
                    ++currentPosition;
                }
            }
            catch (Throwable currentPosition) {
                throwable = currentPosition;
                throw currentPosition;
            }
        }
        log.info((Object)String.format("Fixing stages results positions for %d stages.", stagesResultsToFix.size()));
        for (Pair stage : stagesResultsToFix) {
            PreparedStatement statement = connection.prepareStatement(UPDATE_RESULT_STAGE_POSITION);
            throwable = null;
            try {
                long stageResultId = (Long)stage.getFirst();
                int position = (Integer)stage.getSecond();
                statement.setInt(1, position);
                statement.setLong(2, stageResultId);
                int rowsUpdated = statement.executeUpdate();
                if (rowsUpdated == 1) continue;
                throw new RuntimeException(String.format("Problem when fixing stages results positions. stageResultId=%d; list_position=%d. Updated %d rows while expected 1", stageResultId, position, rowsUpdated));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (statement == null) continue;
                if (throwable != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                statement.close();
            }
        }
    }
}

