/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_12;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.bamboo.utils.db.JdbcUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class UpgradeTask51206RepairStagesListPosition
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask51206RepairStagesListPosition.class);
    private static final String BUILDS_WITH_STAGES_HOLES = "select distinct S1.BUILD_ID from CHAIN_STAGE S1 left join CHAIN_STAGE S2 on (S1.BUILD_ID = S2.BUILD_ID and S1.LIST_POSITION = S2.LIST_POSITION + 1) where S1.LIST_POSITION != 0 and S2.STAGE_ID is null";
    private static final String BUILDS_WITH_STAGES_HOLES_HSQL = "select distinct S1.BUILD_ID from CHAIN_STAGE S1 where S1.LIST_POSITION != 0 and not exists ( select S2.BUILD_ID from CHAIN_STAGE S2 where S1.BUILD_ID = S2.BUILD_ID and S1.LIST_POSITION = S2.LIST_POSITION + 1)";
    private static final String BUILDS_WITH_STAGES_DUPLICATES = "select distinct BUILD_ID from CHAIN_STAGE group by BUILD_ID,LIST_POSITION having count(BUILD_ID)>1";
    private static final String STAGES_POSITIONS_IN_BUILD = "select STAGE_ID, LIST_POSITION from CHAIN_STAGE where BUILD_ID = ? order by LIST_POSITION, STAGE_ID";
    private static final String UPDATE_STAGE_POSITION = "update CHAIN_STAGE set LIST_POSITION = ? where STAGE_ID = ?";
    @Autowired
    private DbmsBean dbmsBean;

    public UpgradeTask51206RepairStagesListPosition() {
        super("Repair Stages List Position");
    }

    public void doUpgrade() throws Exception {
        this.withDatabaseConnection(connection -> {
            HashSet buildsWithStagesToFix = new HashSet();
            String buildsWithStagesHoles = this.dbmsBean.isHsqldb() ? BUILDS_WITH_STAGES_HOLES_HSQL : BUILDS_WITH_STAGES_HOLES;
            buildsWithStagesToFix.addAll(JdbcUtils.getListOfLong((Connection)connection, (String)buildsWithStagesHoles));
            buildsWithStagesToFix.addAll(JdbcUtils.getListOfLong((Connection)connection, (String)BUILDS_WITH_STAGES_DUPLICATES));
            log.info((Object)String.format("Number of builds that have stages positions to fix: %d. Id of builds: %s", buildsWithStagesToFix.size(), buildsWithStagesToFix));
            Iterator iterator = buildsWithStagesToFix.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                this.fixBuildStages(connection, id);
            }
        });
    }

    private void fixBuildStages(@NotNull Connection connection, long buildId) throws SQLException {
        Throwable throwable;
        ArrayList<Pair> stagesToFix = new ArrayList<Pair>();
        try (PreparedStatement statement = connection.prepareStatement(STAGES_POSITIONS_IN_BUILD);){
            statement.setLong(1, buildId);
            throwable = null;
            try (ResultSet resultSet = statement.executeQuery();){
                int currentPosition = 0;
                while (resultSet.next()) {
                    int position = resultSet.getInt(2);
                    if (position != currentPosition) {
                        long stageId = resultSet.getLong(1);
                        stagesToFix.add(Pair.make((Object)stageId, (Object)currentPosition));
                    }
                    ++currentPosition;
                }
            }
            catch (Throwable currentPosition) {
                throwable = currentPosition;
                throw currentPosition;
            }
        }
        log.info((Object)String.format("Fixing stages positions for %d stages.", stagesToFix.size()));
        for (Pair stage : stagesToFix) {
            PreparedStatement statement = connection.prepareStatement(UPDATE_STAGE_POSITION);
            throwable = null;
            try {
                long stageId = (Long)stage.getFirst();
                int position = (Integer)stage.getSecond();
                statement.setInt(1, position);
                statement.setLong(2, stageId);
                int rowsUpdated = statement.executeUpdate();
                if (rowsUpdated == 1) continue;
                throw new RuntimeException(String.format("Problem when fixing stages positions. stageId=%d; list_position=%d. Updated %d rows while expected 1", stageId, position, rowsUpdated));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (statement == null) continue;
                if (throwable != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                statement.close();
            }
        }
    }
}

