/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_12;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.utils.db.DbmsBean;
import java.sql.Connection;
import java.sql.SQLException;
import javax.inject.Inject;
import org.apache.log4j.Logger;

public class UpgradeTask51205DropObsoleteCommitFilesColumn
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask51205DropObsoleteCommitFilesColumn.class);
    private static final String TABLE_NAME = "COMMIT_FILES";
    private static final String FOREIGN_KEY_NAME = "FKA9983D4F4D373123";
    @Inject
    private DbmsBean dbmsBean;

    public UpgradeTask51205DropObsoleteCommitFilesColumn() {
        super("Drop obsolete column in COMMIT_FILES table");
    }

    public void doUpgrade() throws SQLException {
        this.withDatabaseConnection(connection -> {
            if (this.dbmsBean.isMySql()) {
                this.dropForeignKeyConstraint(connection, FOREIGN_KEY_NAME);
            }
            SQLException dropPrimaryKeyException = null;
            log.info((Object)"Dropping primary key on COMMIT_FILES");
            try {
                this.dbmsBean.dropPrimaryKey(connection, TABLE_NAME);
                log.info((Object)"The primary key constraint on COMMIT_FILES has been dropped.");
            }
            catch (SQLException e) {
                dropPrimaryKeyException = e;
                log.info((Object)"The primary key constraint on COMMIT_FILES has NOT been dropped.");
                log.info((Object)"Suppressed exception: ", (Throwable)e);
            }
            try {
                this.dbmsBean.dropColumn(connection, TABLE_NAME, "LIST_POSITION");
            }
            catch (SQLException e) {
                if (dropPrimaryKeyException != null) {
                    log.warn((Object)"The primary key constraint on COMMIT_FILES has NOT been dropped.", (Throwable)dropPrimaryKeyException);
                }
                log.warn((Object)"", (Throwable)e);
            }
        });
    }

    private void dropForeignKeyConstraint(Connection connection, String foreignKeyName) throws SQLException {
        this.dbmsBean.getConstraints(connection, TABLE_NAME, null).stream().filter(constraint -> foreignKeyName.equalsIgnoreCase(constraint.getName())).forEach(constraint -> {
            try {
                this.dbmsBean.dropForeignKeyConstraint(connection, TABLE_NAME, constraint.getName());
                log.info((Object)"Foreign key constraint on COMMIT_FILES has been dropped.");
            }
            catch (SQLException e) {
                log.info((Object)e.getMessage(), (Throwable)e);
            }
        });
    }
}

