/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.v5_11;

import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.core.BambooEntityOidService;
import com.atlassian.bamboo.core.BambooEntityType;
import com.atlassian.bamboo.core.EntityWithOid;
import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractOidAddingUpgradeTask
extends AbstractUpgradeTask {
    @Autowired
    protected BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate;
    @Autowired
    private BambooEntityOidService bambooEntityOidService;

    public AbstractOidAddingUpgradeTask(@NotNull String shortDescription) {
        super(shortDescription);
    }

    protected boolean setOidIfMissing(@NotNull EntityWithOid entity) {
        if (entity.getOid() == null) {
            entity.setOid(this.bambooEntityOidService.nextOid(entity.getEntityType()));
            return true;
        }
        return false;
    }

    protected boolean recalculateOid(@NotNull EntityWithOid entity, int newServerKey) {
        if (entity.getOid() == null) {
            return this.setOidIfMissing(entity);
        }
        BambooEntityOid oldOid = entity.getOid();
        BambooEntityOid newOid = BambooEntityOid.create((int)newServerKey, (BambooEntityType)oldOid.getEntityType(), (long)oldOid.getEntityOid());
        if (oldOid.getValue() != newOid.getValue()) {
            entity.setOid(newOid);
            return true;
        }
        return false;
    }
}

