/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.util;

import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class ForeignKeyConstraintUtils {
    private ForeignKeyConstraintUtils() {
    }

    public static HashMultimap<String, String> getAllForeignKeyConstraints(DbmsBean dbmsBean, Connection c, Collection<String> tables) {
        try (Ticker ignored = Timers.start((String)"getAllForeignKeyConstraints");){
            HashMultimap tablesAndForeignKeys = HashMultimap.create();
            for (String tableName : tables) {
                ForeignKeyConstraintUtils.getConstraints(dbmsBean, c, tableName).stream().filter(DbmsBean.ConstraintDefinition::isForeignKey).filter(fk -> StringUtils.startsWithIgnoreCase((CharSequence)fk.getName(), (CharSequence)"fk")).forEach(fk -> tablesAndForeignKeys.put((Object)tableName, (Object)fk.getName()));
            }
            HashMultimap hashMultimap = tablesAndForeignKeys;
            return hashMultimap;
        }
    }

    public static void dropForeignKeyConstraint(DbmsBean dbmsBean, Connection c, String tableName, String constraint) {
        try {
            dbmsBean.dropForeignKeyConstraint(c, tableName, constraint);
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static Collection<DbmsBean.ConstraintDefinition> getConstraints(DbmsBean dbmsBean, Connection c, String tableName) {
        try {
            return dbmsBean.getConstraints(c, tableName, null);
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

