/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.repeatable;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.AdministrationConfigurationPersister;
import com.atlassian.bamboo.configuration.RssSecurityConfiguration;
import com.atlassian.bamboo.docker.BambooDockerHelper;
import com.atlassian.bamboo.upgrade.AbstractRepeatableTask;
import com.atlassian.plugin.util.VersionStringComparator;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateSpecsRunnerDockerImage
extends AbstractRepeatableTask {
    private static final Logger log = Logger.getLogger(UpdateSpecsRunnerDockerImage.class);
    private static final String DOCKER_IMAGE_TAG_SEPARATOR = ":";
    @Inject
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    @Inject
    private AdministrationConfigurationPersister administrationConfigurationPersister;

    public UpdateSpecsRunnerDockerImage() {
        super("60401", "Update Docker image for running Bamboo Specs");
    }

    protected boolean needsUpgrade() {
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        RssSecurityConfiguration rssSecurityConfiguration = administrationConfiguration.getRssSecurityConfiguration();
        String currentDockerImage = StringUtils.defaultString((String)rssSecurityConfiguration.getDockerImage());
        String defaultDockerImage = this.getDefaultDockerImage();
        log.debug((Object)String.format("Current Docker image: '%s'", currentDockerImage));
        log.debug((Object)String.format("Default Docker image: '%s'", defaultDockerImage));
        if (StringUtils.endsWith((CharSequence)defaultDockerImage, (CharSequence)"-SNAPSHOT")) {
            log.info((Object)"Detected SNAPSHOT version of Bamboo Specs, skipping upgrade");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)currentDockerImage)) {
            log.info((Object)String.format("Current Docker image not specified, setting it to '%s'", defaultDockerImage));
            return true;
        }
        if (Objects.equals(currentDockerImage, defaultDockerImage)) {
            log.info((Object)"Already using most recent Docker image for Bamboo Specs, skipping upgrade");
            return false;
        }
        String defaultDockerImageName = StringUtils.substringBeforeLast((String)defaultDockerImage, (String)DOCKER_IMAGE_TAG_SEPARATOR);
        log.debug((Object)String.format("Default Docker image name: '%s'", defaultDockerImageName));
        if (!Objects.equals(currentDockerImage, defaultDockerImageName) && !currentDockerImage.startsWith(defaultDockerImageName + DOCKER_IMAGE_TAG_SEPARATOR)) {
            log.info((Object)"Detected custom Docker image for Bamboo Specs, skipping upgrade");
            return false;
        }
        String currentDockerImageTag = StringUtils.substring((String)currentDockerImage, (int)(defaultDockerImageName.length() + 1));
        String defaultDockerImageTag = StringUtils.substring((String)defaultDockerImage, (int)(defaultDockerImageName.length() + 1));
        log.debug((Object)String.format("Current Docker image tag: '%s'", currentDockerImageTag));
        log.debug((Object)String.format("Default Docker image tag: '%s'", defaultDockerImageTag));
        if (!this.isComparableTag(currentDockerImageTag) || !this.isComparableTag(defaultDockerImageTag)) {
            log.info((Object)"Couldn't compare tags/versions of Docker images for Bamboo Specs, skipping upgrade");
            return false;
        }
        String currentDockerImageComparableVersion = this.toComparableVersion(currentDockerImageTag);
        String defaultDockerImageComparableVersion = this.toComparableVersion(defaultDockerImageTag);
        log.debug((Object)String.format("Current Docker image comparable version: '%s'", currentDockerImageTag));
        log.debug((Object)String.format("Default Docker image comparable version: '%s'", defaultDockerImageTag));
        VersionStringComparator versionComparator = new VersionStringComparator();
        if (versionComparator.compare(currentDockerImageComparableVersion, defaultDockerImageComparableVersion) > 0) {
            log.info((Object)"Detected newer version of default Docker image for Bamboo Specs, skipping upgrade");
            return false;
        }
        log.info((Object)String.format("Detected older version of default Docker image for Bamboo Specs, upgrading from '%s' to '%s'", currentDockerImage, defaultDockerImage));
        return true;
    }

    protected void doRepeatableTask() throws Exception {
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        RssSecurityConfiguration rssSecurityConfiguration = administrationConfiguration.getRssSecurityConfiguration();
        RssSecurityConfiguration updatedRssSecurityConfiguration = new RssSecurityConfiguration(rssSecurityConfiguration.isEnabled(), rssSecurityConfiguration.isExecuteSpecsInDocker(), this.getDefaultDockerImage(), rssSecurityConfiguration.isMountLocalMavenDirectory(), rssSecurityConfiguration.getLocalMavenDirectory());
        administrationConfiguration.setRssSecurityConfiguration(updatedRssSecurityConfiguration);
        this.administrationConfigurationPersister.saveAdministrationConfiguration(administrationConfiguration);
    }

    private boolean isComparableTag(@Nullable String dockerImageTag) {
        return StringUtils.isBlank((CharSequence)dockerImageTag) || VersionStringComparator.isValidVersionString((String)dockerImageTag);
    }

    @NotNull
    private String toComparableVersion(@Nullable String dockerImageTag) {
        return Optional.ofNullable(dockerImageTag).filter(StringUtils::isNotBlank).filter(VersionStringComparator::isValidVersionString).orElse("0");
    }

    @VisibleForTesting
    String getDefaultDockerImage() {
        return BambooDockerHelper.DEFAULT_RSS_DOCKER_IMAGE;
    }
}

