/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.repeatable;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.collections.message.FinalHashSet;
import com.atlassian.bamboo.upgrade.tasks.v5_14.AbstractConvertRepositoryTypesUpgrade;
import com.atlassian.bamboo.vcs.converter.Repository2VcsTypeConverter;
import com.atlassian.bamboo.vcs.viewer.converter.Web2VcsRepositoryViewerConverter;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.plugin.PluginAccessor;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class ConvertRepositoryTypes
extends AbstractConvertRepositoryTypesUpgrade {
    private static final Logger log = Logger.getLogger(ConvertRepositoryTypes.class);
    private String TASK_IN_PROGRESS = "com.atlassian.bamboo.upgrade.tasks.repeatable.ConvertRepositoryTypes.inprogress";
    @Autowired
    PluginAccessor pluginAccessor;
    @Autowired
    BandanaManager bandanaManager;

    public ConvertRepositoryTypes() {
        super("51409", "Convert legacy repository types if new converters available");
    }

    private boolean needsUpgrade() {
        if (Boolean.TRUE.equals(this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, this.TASK_IN_PROGRESS))) {
            log.info((Object)"Re-running the task, as previous run has been interrupted");
            return true;
        }
        Set legacyVcsPluginKeys = (Set)this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "legacy.vcs.plugins.used");
        if (CollectionUtils.isNotEmpty((Collection)legacyVcsPluginKeys)) {
            Set repositoryPluginKeysWithConverters = this.pluginAccessor.getEnabledModulesByClass(Repository2VcsTypeConverter.class).stream().map(Repository2VcsTypeConverter::acceptedRepositoryPluginKey).collect(Collectors.toSet());
            Set viewerPluginKeysWithConverters = this.pluginAccessor.getEnabledModulesByClass(Web2VcsRepositoryViewerConverter.class).stream().map(Web2VcsRepositoryViewerConverter::acceptedWebRepositoryViewerPluginKey).collect(Collectors.toSet());
            boolean converterFound = false;
            List pluginsWithConverters = legacyVcsPluginKeys.stream().filter(pluginKey -> repositoryPluginKeysWithConverters.contains(pluginKey) || viewerPluginKeysWithConverters.contains(pluginKey)).collect(Collectors.toList());
            if (!pluginsWithConverters.isEmpty()) {
                log.info((Object)("Converters found for the following plugins: " + StringUtils.join(pluginsWithConverters, (String)", ")));
                log.info((Object)"Running the upgrade");
                return true;
            }
        }
        return false;
    }

    private void doRepeatableTask() throws Exception {
        this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, this.TASK_IN_PROGRESS, (Object)true);
        this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "legacy.vcs.plugins.used", (Object)new FinalHashSet());
        this.upgradeRepositories();
        this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, this.TASK_IN_PROGRESS, (Object)false);
    }

    public void doUpgrade() throws Exception {
        if (this.needsUpgrade()) {
            this.doRepeatableTask();
        } else {
            log.debug((Object)"Nothing to be done.");
        }
    }
}

