/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.repeatable;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.upgrade.AbstractRepeatableTask;
import com.atlassian.bamboo.upgrade.UpgradeManager;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class AddIndicesToForeignKeys
extends AbstractRepeatableTask {
    private static final Logger log = Logger.getLogger(AddIndicesToForeignKeys.class);
    private static final String BUILD_NUMBER_OF_LAST_RUN = "com.atlassian.bamboo.upgrade.tasks.repeatable.AddIndicesToForeignKeys:buildNumber";
    @Inject
    private DbmsBean dbmsBean;
    @Inject
    private HibernateTemplate hibernateTemplate;
    @Inject
    private BandanaManager bandanaManager;
    @Inject
    private UpgradeManager upgradeManager;

    public AddIndicesToForeignKeys() {
        super("60204", "Add indexes to support foreign keys");
    }

    protected boolean needsUpgrade() {
        String buildNumberOfLastIndexSync;
        if (this.dbmsBean.isMySql() || this.dbmsBean.isH2()) {
            return false;
        }
        String currentBuildNumber = this.upgradeManager.getBuildNumber();
        return !currentBuildNumber.equals(buildNumberOfLastIndexSync = (String)this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, BUILD_NUMBER_OF_LAST_RUN));
    }

    protected void doRepeatableTask() throws Exception {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.hibernateTemplate.execute(session -> {
            this.performUpgrade(session);
            this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, BUILD_NUMBER_OF_LAST_RUN, (Object)this.upgradeManager.getBuildNumber());
            return null;
        });
        log.info((Object)("Index creation finished after " + stopwatch));
    }

    @VisibleForTesting
    public Set<String> performUpgrade(Session session) {
        log.info((Object)"Getting FK constraints...");
        SetMultimap columnsToIndex = MultimapBuilder.treeKeys().hashSetValues().build();
        HashMap<Pair<String, List<String>>, String> constraintNames = new HashMap<Pair<String, List<String>>, String>();
        this.getAllFkConstraints(session, (SetMultimap<String, List<String>>)columnsToIndex, constraintNames);
        log.info((Object)"Creating indices...");
        HashSet<String> indicesNeeded = new HashSet<String>();
        for (Map.Entry index : columnsToIndex.entries()) {
            try {
                String tableName = (String)index.getKey();
                List columns = (List)index.getValue();
                String fkName = constraintNames.get(Pair.of((Object)tableName, (Object)columns));
                String indexName = this.getIndexName(fkName);
                Set existingIndices = (Set)session.doReturningWork(c -> this.dbmsBean.getIndexNames(c, tableName, null));
                if (existingIndices.contains(indexName)) continue;
                indicesNeeded.add(indexName);
                this.createIndex(session, indexName, tableName, columns);
            }
            catch (Exception e) {
                log.warn((Object)"", (Throwable)e);
            }
        }
        return indicesNeeded;
    }

    private String getIndexName(String fkName) {
        if (!StringUtils.startsWithIgnoreCase((CharSequence)fkName, (CharSequence)"fk")) {
            return fkName;
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)fkName, (CharSequence)"fk_ao_")) {
            String newFkName = StringUtils.replaceOnce((String)fkName, (String)"FK_AO_", (String)"FKIX_");
            return StringUtils.replaceOnce((String)newFkName, (String)"fk_ao_", (String)"fkix_");
        }
        String newFkName = StringUtils.replaceOnce((String)fkName, (String)"FK", (String)"FKIX");
        return StringUtils.replaceOnce((String)newFkName, (String)"fk", (String)"fkix");
    }

    private void getAllFkConstraints(Session session, SetMultimap<String, List<String>> columnsToIndex, HashMap<Pair<String, List<String>>, String> constraintNames) {
        log.info((Object)"Scanning for FKs that do not have system indices...");
        session.doWork(connection -> {
            List tables = this.dbmsBean.getTables(connection);
            for (String table : tables) {
                log.info((Object)("Processing table " + table));
                Collection allConstraints = this.dbmsBean.getConstraints(connection, table, null);
                log.info((Object)("Retrieved constraints of table " + table));
                Set columnsCoveredByAutomaticIndexes = allConstraints.stream().filter(c -> c.isUniqueKey() || c.isPrimaryKey()).map(DbmsBean.ConstraintDefinition::getColumns).map(ArrayList::new).collect(Collectors.toSet());
                Set columnsThatNeedFkIndex = allConstraints.stream().filter(DbmsBean.ConstraintDefinition::isForeignKey).map(DbmsBean.ConstraintDefinition::getColumns).map(ArrayList::new).collect(Collectors.toSet());
                columnsThatNeedFkIndex.removeAll(columnsCoveredByAutomaticIndexes);
                if (!columnsThatNeedFkIndex.isEmpty()) {
                    columnsToIndex.putAll((Object)table, columnsThatNeedFkIndex);
                }
                allConstraints.stream().filter(DbmsBean.ConstraintDefinition::isForeignKey).forEach(c -> constraintNames.put(Pair.of((Object)table, new ArrayList(c.getColumns())), c.getName()));
            }
        });
        log.info((Object)"FKs that need indices retrieved.");
    }

    private void createIndex(Session session, String indexName, String tableName, List<String> columnList) {
        String columnListString = Joiner.on((char)',').join(columnList);
        session.doWork(connection -> {
            log.info((Object)("Creating index " + indexName + " on " + tableName + " (" + columnListString + ")"));
            try {
                this.dbmsBean.createIndex(connection, indexName, tableName, (String)Iterables.getOnlyElement((Iterable)columnList));
            }
            catch (SQLException e) {
                log.warn((Object)("Couldn't create index. If an equivalent index has been manually set up, remove it, it's no longer neeed. Error: " + e));
            }
        });
    }
}

