/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks;

import com.atlassian.bamboo.build.pipeline.concurrent.SystemAuthorityThreadFactory;
import com.atlassian.bamboo.util.BambooHibernateUtils;
import com.atlassian.config.db.HibernateConfig;
import com.atlassian.upgrade.UpgradeException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class MultiThreadedUpgradeRunner {
    private static final Logger log = Logger.getLogger(MultiThreadedUpgradeRunner.class);
    private final AtomicReference<Throwable> exceptionReference = new AtomicReference();
    private final ThreadPoolExecutor executorService;
    private final Semaphore token;

    public MultiThreadedUpgradeRunner(int maxThreads) {
        this(maxThreads, maxThreads * 2);
    }

    public MultiThreadedUpgradeRunner(int numberOfThreads, int queueCapacity) {
        this.executorService = new ThreadPoolExecutor(numberOfThreads, numberOfThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new SystemAuthorityThreadFactory("UpgradeTask"));
        this.token = new Semaphore(queueCapacity);
        log.info((Object)("Limiting to " + numberOfThreads + " concurrent threads and queue of " + queueCapacity));
    }

    public MultiThreadedUpgradeRunner(@NotNull HibernateConfig hibernateConfig) {
        this(BambooHibernateUtils.getConcurrentPoolSize((HibernateConfig)hibernateConfig));
    }

    public void submit(final @NotNull Callable<Void> callable) throws InterruptedException, UpgradeException {
        boolean isTaskSubmitted = false;
        this.token.acquire();
        try {
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        callable.call();
                    }
                    catch (Exception e) {
                        log.error((Object)"Exception occurred during upgrade. Upgrade will stop...", (Throwable)e);
                        MultiThreadedUpgradeRunner.this.exceptionReference.set(e);
                        List<Runnable> list = MultiThreadedUpgradeRunner.this.executorService.shutdownNow();
                        if (!list.isEmpty()) {
                            log.warn((Object)(list.size() + " queued task(s) not run"));
                        }
                    }
                    finally {
                        MultiThreadedUpgradeRunner.this.token.release();
                    }
                }
            });
            isTaskSubmitted = true;
        }
        catch (RejectedExecutionException rej) {
            this.token.release();
            if (this.executorService.isShutdown()) {
                this.checkException();
            }
            throw rej;
        }
        finally {
            if (!isTaskSubmitted) {
                this.token.release();
            }
        }
    }

    public void waitForTermination() throws InterruptedException, UpgradeException {
        log.info((Object)"Shutting down");
        this.executorService.shutdown();
        log.info((Object)"Terminating");
        this.executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        this.checkException();
    }

    public void checkException() throws UpgradeException {
        Throwable throwable = this.getException();
        if (throwable != null) {
            log.info((Object)"Throwing exception");
            throw new UpgradeException("Unable to upgrade: " + throwable.getMessage(), throwable);
        }
    }

    public int getActiveThreads() {
        return this.executorService.getActiveCount();
    }

    private Throwable getException() {
        return this.exceptionReference.get();
    }
}

