/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks;

import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.utils.db.DbmsBean;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.orm.hibernate5.HibernateCallback;

public class AbstractVariableDataEncryptionTask
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(AbstractVariableDataEncryptionTask.class);
    private static final int PAGE_SIZE = 500;
    private static final String ENCRYPTED_STRING_PREFIX = "BAMSCRT";
    private static final String VARIABLE_NOT_ENCRYPTED = " and VARIABLE_VALUE not like 'BAMSCRT%'";
    @Autowired
    private BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate;
    @Autowired
    private DbmsBean dbmsBean;
    @Autowired
    @Lazy
    private SecretEncryptionService secretEncryptionService;
    private final String tableName;
    private final String idFieldName;

    public AbstractVariableDataEncryptionTask(@NotNull String description, @NotNull String tableName) {
        this(description, tableName, tableName + "_ID");
    }

    public AbstractVariableDataEncryptionTask(String description, String tableName, String idFieldName) {
        super(description);
        this.tableName = tableName;
        this.idFieldName = idFieldName;
    }

    public void doUpgrade() throws Exception {
        long updatedCount = this.dbmsBean.isOracle() || this.dbmsBean.isMsSqlServer() ? this.updateVariableValuesById() : this.updateVariableValuesByValue();
        log.info((Object)("Finished encryption of variable definitions. Encrypted " + updatedCount + " items"));
    }

    private long updateVariableValuesById() {
        boolean hasMoreRecords;
        AtomicLong count = new AtomicLong();
        long size = this.calculateRecords();
        log.info((Object)("Found " + size + " " + this.tableName + " records to be encrypted"));
        String predicateForSecretFields = this.getPredicateForSecretFields();
        do {
            hasMoreRecords = (Boolean)this.bambooTransactionHibernateTemplate.execute(session -> {
                NativeQuery criteria = session.createNativeQuery("select " + this.idFieldName + ", VARIABLE_KEY, VARIABLE_VALUE from " + this.tableName + " where " + predicateForSecretFields + VARIABLE_NOT_ENCRYPTED + " order by " + this.idFieldName);
                criteria.setMaxResults(500);
                NativeQuery updateQuery = session.createNativeQuery("update " + this.tableName + " set VARIABLE_VALUE=:value where " + this.idFieldName + "=:id");
                List list = criteria.list();
                if (list.isEmpty()) {
                    return false;
                }
                for (Object[] vd : list) {
                    String value = this.readValue(vd[2]);
                    String key = vd[1].toString();
                    String encryptedValue = this.secretEncryptionService.encrypt(value);
                    updateQuery.setParameter("value", (Object)encryptedValue);
                    updateQuery.setParameter("id", (Object)Long.valueOf(vd[0].toString()));
                    updateQuery.executeUpdate();
                    count.incrementAndGet();
                }
                return list.size() == 500;
            });
            log.info((Object)("Encrypted " + count.get() + " records"));
        } while (hasMoreRecords);
        return count.get();
    }

    private String readValue(@NotNull Object value) {
        if (value instanceof Clob) {
            try {
                Clob clob = (Clob)value;
                return clob.getSubString(1L, (int)clob.length());
            }
            catch (SQLException e) {
                throw new RuntimeException("Error while converting clob : " + value, e);
            }
        }
        return StringUtils.defaultString((String)value.toString(), (String)"");
    }

    private long updateVariableValuesByValue() {
        boolean hasMoreRecords;
        AtomicLong updatedCount = new AtomicLong();
        long size = this.calculateUniqueRecords();
        log.info((Object)("Found " + size + " unique variable definition values to be encrypted"));
        while (hasMoreRecords = ((Boolean)this.bambooTransactionHibernateTemplate.execute(this.updatedVariablesByUniqueValue(updatedCount))).booleanValue()) {
        }
        return updatedCount.get();
    }

    @NotNull
    private HibernateCallback<Boolean> updatedVariablesByUniqueValue(AtomicLong updatedCount) {
        return session -> {
            String predicateForSecretFields = this.getPredicateForSecretFields();
            NativeQuery criteria = session.createNativeQuery("select distinct VARIABLE_VALUE from " + this.tableName + " where " + predicateForSecretFields + VARIABLE_NOT_ENCRYPTED).setMaxResults(500);
            List list = criteria.list();
            if (list.isEmpty()) {
                log.info((Object)"List is empty. Finishing...");
                return false;
            }
            log.info((Object)("Updating " + list.size() + " records"));
            NativeQuery query = session.createNativeQuery("update " + this.tableName + " set VARIABLE_VALUE=:encrypted_value where VARIABLE_VALUE=:value and " + predicateForSecretFields);
            for (String value : list) {
                if (StringUtils.isEmpty((CharSequence)value)) continue;
                this.encryptVariableValue(updatedCount, session, value, query);
            }
            log.info((Object)("Updated " + updatedCount.get() + " rows"));
            return list.size() == 500;
        };
    }

    private void encryptVariableValue(AtomicLong updatedCount, Session session, String value, NativeQuery query) {
        String encryptedValue = this.secretEncryptionService.encrypt(value);
        query.setParameter("value", (Object)value);
        query.setParameter("encrypted_value", (Object)encryptedValue);
        int updated = query.executeUpdate();
        updatedCount.addAndGet(updated);
    }

    @NotNull
    private String getPredicateForSecretFields() {
        String lowerCaseVariableKeyColumn = this.dbmsBean.toLowerCase("VARIABLE_KEY");
        return String.format("(%s)", PasswordMaskingUtils.PASSWORD_FIELD_NAMES.stream().map(key -> "(" + lowerCaseVariableKeyColumn + " like '%" + key.toLowerCase(Locale.US) + "%')").collect(Collectors.joining(" or ")));
    }

    private long calculateUniqueRecords() {
        return (Long)this.bambooTransactionHibernateTemplate.execute(session -> {
            NativeQuery variablesToBeEncrypted = session.createNativeQuery("select count(distinct VARIABLE_VALUE) from " + this.tableName + " where " + this.getPredicateForSecretFields() + VARIABLE_NOT_ENCRYPTED);
            return ((Number)variablesToBeEncrypted.getSingleResult()).longValue();
        });
    }

    private long calculateRecords() {
        return (Long)this.bambooTransactionHibernateTemplate.execute(session -> {
            NativeQuery variablesToBeEncrypted = session.createNativeQuery("select count(" + this.idFieldName + ") from " + this.tableName + " where " + this.getPredicateForSecretFields() + VARIABLE_NOT_ENCRYPTED);
            return ((Number)variablesToBeEncrypted.getSingleResult()).longValue();
        });
    }
}

