/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractUpdateHibernateDialectUpgradeTask
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(AbstractUpdateHibernateDialectUpgradeTask.class);
    private static final String HIBERNATE_DIALECT = "hibernate.dialect";

    public AbstractUpdateHibernateDialectUpgradeTask() {
        super("Update Hibernate dialect in bamboo.cfg.xml");
    }

    public void doUpgrade() throws Exception {
        String dialect = this.bootstrapManager.getString(HIBERNATE_DIALECT);
        String newDialect = this.getNewDialect(dialect);
        if (newDialect == null) {
            log.warn((Object)"No change needed.");
            return;
        }
        log.info((Object)("Updating Hibernate dialect in bamboo.cfg.xml: " + dialect + " -> " + newDialect));
        this.bootstrapManager.removeProperty(HIBERNATE_DIALECT);
        this.bootstrapManager.setProperty(HIBERNATE_DIALECT, (Object)newDialect);
        this.bootstrapManager.save();
        log.info((Object)"Hibernate dialect updated successfully");
    }

    @Nullable
    protected abstract String getNewDialect(String var1);
}

