/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks;

import com.atlassian.bamboo.build.BuildDefinitionForBuild;
import com.atlassian.bamboo.build.BuildDefinitionXml;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.deployments.environments.persistence.EnvironmentDao;
import com.atlassian.bamboo.deployments.environments.persistence.MutableEnvironment;
import com.atlassian.bamboo.deployments.projects.persistence.DeploymentProjectDao;
import com.atlassian.bamboo.deployments.projects.persistence.MutableDeploymentProject;
import com.atlassian.bamboo.fieldvalue.TaskConfigurationUtils;
import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.plan.PlanDao;
import com.atlassian.bamboo.plan.PlanPredicates;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractTaskConfigurationUpgradeTask
extends AbstractUpgradeTask {
    private static final int PAGE_SIZE = 100;
    private static final String BUILD_TASK_CFG_PREFIX = "buildTasks.";
    private static final String DEPLOYMENT_TASK_CFG_PREFIX = "";
    private static final Logger log = Logger.getLogger(AbstractTaskConfigurationUpgradeTask.class);
    @Autowired
    private BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate;
    @Autowired
    private PlanDao planDao;
    @Autowired
    private DeploymentProjectDao deploymentProjectDao;
    @Autowired
    private EnvironmentDao environmentDao;

    protected AbstractTaskConfigurationUpgradeTask(@NotNull String shortDescription) {
        super(shortDescription);
    }

    public void doUpgrade() throws Exception {
        this.updatePlans();
        this.updateEnvironments();
    }

    private void updatePlans() {
        int numberOfChains = this.planDao.getPlanCount(Chain.class);
        for (int i = 0; i < numberOfChains; i += 100) {
            int firstResult = i;
            this.bambooTransactionHibernateTemplate.doWork(connection -> this.planDao.findAllPlans(Chain.class, firstResult, 100).stream().filter(PlanPredicates::planIsMaster).flatMap(plan -> plan.getAllJobs().stream()).forEach(this::upgradeJob));
        }
    }

    @VisibleForTesting
    public void upgradeJob(Job job) {
        BuildDefinitionForBuild buildDefinitionXml = job.getBuildDefinitionXml();
        if (buildDefinitionXml == null || buildDefinitionXml.getXmlData() == null || this.jobCanBeSkipped((BuildDefinitionXml)buildDefinitionXml)) {
            log.info((Object)("Nothing to do for " + job.getPlanKey()));
            return;
        }
        BuildConfiguration buildConfiguration = new BuildConfiguration(buildDefinitionXml.getXmlData());
        List tasks = TaskConfigurationUtils.getTaskDefinitionsFromConfig((String)BUILD_TASK_CFG_PREFIX, (HierarchicalConfiguration)buildConfiguration);
        int updatedTasks = this.updateTaskDefinitions(tasks);
        if (updatedTasks != 0) {
            TaskConfigurationUtils.removeTasksFromConfig((HierarchicalConfiguration)buildConfiguration);
            TaskConfigurationUtils.addTaskDefinitionsToConfig((List)tasks, (HierarchicalConfiguration)buildConfiguration, (String)BUILD_TASK_CFG_PREFIX);
            buildDefinitionXml.setXmlData(buildConfiguration.asXml());
            this.planDao.save((BambooObject)job);
        }
    }

    protected boolean jobCanBeSkipped(@NotNull BuildDefinitionXml buildDefinitionXml) {
        return false;
    }

    protected abstract boolean updateTaskDefinition(TaskDefinition var1);

    private void updateEnvironments() {
        for (MutableDeploymentProject deploymentProject : this.deploymentProjectDao.getAllDeploymentProjects()) {
            this.bambooTransactionHibernateTemplate.doWork(session -> this.environmentDao.getEnvironmentsForDeploymentProject(deploymentProject.getId()).forEach(this::upgradeEnvironment));
        }
    }

    private void upgradeEnvironment(MutableEnvironment environment) {
        BuildConfiguration buildConfiguration = new BuildConfiguration(environment.getTasksXmlData());
        if (this.environmentCanBeSkipped(buildConfiguration)) {
            log.debug((Object)("Environment skipped " + environment.getName()));
            return;
        }
        List tasks = TaskConfigurationUtils.getTaskDefinitionsFromConfig((String)DEPLOYMENT_TASK_CFG_PREFIX, (HierarchicalConfiguration)buildConfiguration);
        int updatedTasksCnt = this.updateTaskDefinitions(tasks);
        if (updatedTasksCnt != 0) {
            BuildConfiguration newConfiguration = new BuildConfiguration();
            TaskConfigurationUtils.addTaskDefinitionsToConfig((List)tasks, (HierarchicalConfiguration)newConfiguration, (String)DEPLOYMENT_TASK_CFG_PREFIX);
            environment.setTasksXmlData(newConfiguration.asXml());
            this.environmentDao.save(environment);
        }
    }

    protected boolean environmentCanBeSkipped(BuildConfiguration buildConfiguration) {
        return false;
    }

    private int updateTaskDefinitions(Iterable<TaskDefinition> tasks) {
        int updatedTasks = 0;
        for (TaskDefinition task : tasks) {
            if (!this.updateTaskDefinition(task)) continue;
            ++updatedTasks;
        }
        return updatedTasks;
    }
}

