/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks;

import com.atlassian.bamboo.upgrade.tasks.AbstractInHibernateTransactionUpgradeTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractStatementUpgradeTask
extends AbstractInHibernateTransactionUpgradeTask {
    private static final Logger log = Logger.getLogger(AbstractStatementUpgradeTask.class);

    protected AbstractStatementUpgradeTask(@NotNull String buildNumber, @NotNull String shortDescription) {
        super(buildNumber, shortDescription);
    }

    protected AbstractStatementUpgradeTask(@NotNull String shortDescription) {
        super(shortDescription);
    }

    @Override
    public void doUpgrade(@NotNull Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            if (this.isShouldRunUpgrade(statement)) {
                for (String sqlStatement : this.getSqlStatements()) {
                    log.info((Object)("Executing SQL: " + sqlStatement));
                    try {
                        statement.execute(sqlStatement);
                        log.info((Object)("Successfully run: " + sqlStatement));
                    }
                    catch (SQLException e) {
                        String error = "Unable to run " + sqlStatement + " : " + e.getMessage();
                        log.error((Object)error, (Throwable)e);
                        this.errors.add(error);
                        throw e;
                    }
                }
            } else {
                log.info((Object)"Upgrade task not run as detected that it is now obsolete");
            }
        }
    }

    protected abstract boolean isShouldRunUpgrade(@NotNull Statement var1) throws SQLException;

    @NotNull
    protected abstract List<String> getSqlStatements();
}

