/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks;

import com.atlassian.bamboo.upgrade.tasks.AbstractInHibernateTransactionUpgradeTask;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPreparedStatementUpgradeTask
extends AbstractInHibernateTransactionUpgradeTask {
    private static final Logger log = Logger.getLogger(AbstractPreparedStatementUpgradeTask.class);

    protected AbstractPreparedStatementUpgradeTask(@NotNull String buildNumber, @NotNull String shortDescription) {
        super(buildNumber, shortDescription);
    }

    protected AbstractPreparedStatementUpgradeTask(@NotNull String shortDescription) {
        super(shortDescription);
    }

    @Override
    public void doUpgrade(@NotNull Connection connection) throws SQLException {
        block27: {
            String preparedStatementSql = this.getPreparedStatementSql();
            try (Statement validationStatement = connection.createStatement();){
                if (this.isShouldRunUpgrade(validationStatement)) {
                    try (PreparedStatement statement = connection.prepareStatement(preparedStatementSql);){
                        this.prepareStatement(statement);
                        int rowCount = statement.executeUpdate();
                        log.info((Object)(rowCount + " rows updated with query " + preparedStatementSql));
                        break block27;
                    }
                }
                log.info((Object)"Upgrade task not run as detected that it is now obsolete");
            }
            catch (SQLException e) {
                String error = "Unable to run " + preparedStatementSql + " : " + e.getMessage();
                this.errors.add(error);
                log.error((Object)error, (Throwable)e);
                throw e;
            }
        }
    }

    protected abstract String getPreparedStatementSql();

    protected abstract void prepareStatement(PreparedStatement var1) throws SQLException;

    protected boolean isShouldRunUpgrade(@NotNull Statement statement) {
        return true;
    }
}

