/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.upgrade.tasks.v6_4.UpgradeTask60402PrepareForAddingDeletionCascades;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.google.common.collect.Iterables;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.springframework.context.annotation.Lazy;

public abstract class AbstractPrepareForAddingDeletionCascadesUpgradeTask
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask60402PrepareForAddingDeletionCascades.class);
    @Lazy
    @Inject
    private DbmsBean dbmsBean;

    protected AbstractPrepareForAddingDeletionCascadesUpgradeTask(String shortDescription) {
        super(shortDescription);
    }

    protected void dropForeignKey(Connection connection, String table, String column) throws SQLException {
        if (!this.dbmsBean.isTablePresent(connection, table)) {
            return;
        }
        Collection fks = this.dbmsBean.getConstraints(connection, table, column).stream().filter(DbmsBean.ConstraintDefinition::isForeignKey).collect(Collectors.toList());
        if (fks.isEmpty()) {
            return;
        }
        DbmsBean.ConstraintDefinition fk = (DbmsBean.ConstraintDefinition)Iterables.getOnlyElement((Iterable)fks);
        log.info((Object)("Dropping " + fk));
        this.dbmsBean.dropForeignKeyConstraint(connection, table, fk.getName());
    }
}

