/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks;

import com.atlassian.bamboo.persister.xstream.CustomizableXStreamFactory;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.upgrade.tasks.AbstractPhase1MoveAdminConfigToDatabaseUpgradeTask;
import com.google.common.base.Preconditions;
import java.io.File;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractPhase2MoveAdminConfigToDatabaseUpgradeTask
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(AbstractPhase2MoveAdminConfigToDatabaseUpgradeTask.class);
    @Autowired
    protected CustomizableXStreamFactory xstreamFactory;
    @Autowired
    private AutowireCapableBeanFactory beanFactory;
    @NotNull
    protected final AbstractPhase1MoveAdminConfigToDatabaseUpgradeTask phase1UpgradeTask;

    protected AbstractPhase2MoveAdminConfigToDatabaseUpgradeTask(@NotNull String shortDescription, @NotNull AbstractPhase1MoveAdminConfigToDatabaseUpgradeTask phase1UpgradeTask) {
        super(shortDescription);
        this.phase1UpgradeTask = phase1UpgradeTask;
    }

    @PostConstruct
    private void postConstruct() {
        this.beanFactory.autowireBean((Object)this.phase1UpgradeTask);
    }

    @Nullable
    protected File getValidPhase1File() {
        File temporaryConfigFile = this.phase1UpgradeTask.getTemporaryConfigFile();
        if (!temporaryConfigFile.exists()) {
            log.info((Object)("Temporary file " + temporaryConfigFile.getAbsolutePath() + " does not exist, skipping upgrade task."));
            return null;
        }
        Preconditions.checkState((boolean)temporaryConfigFile.canRead(), (Object)("Unable to read " + temporaryConfigFile.getAbsolutePath()));
        Preconditions.checkArgument((boolean)temporaryConfigFile.isFile(), (Object)("Not a file: " + temporaryConfigFile.getAbsolutePath()));
        return temporaryConfigFile;
    }
}

