/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.utils.BambooCallables;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.google.common.collect.HashMultimap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractMSSQLConvertColumnUpgradeTask
extends AbstractBootstrapUpgradeTask {
    private static final int OLD_BIGINT_SIZE = 19;
    public static final Predicate<DbmsBean.ColumnDefinition> IS_NUMERIC_19_COLUMN = column -> column.getDataType() == 2 && column.getColumnSize().orElse(-1) == 19;
    private static final String[] ALL_TABLES = new String[]{"ACL_ENTRY", "ACL_OBJECT_IDENTITY", "AGENT_ASSIGNMENT", "AGENT_AUTHENTICATION", "ARTIFACT", "ARTIFACT_DEFINITION", "ARTIFACT_SUBSCRIPTION", "AUDIT_LOG", "AUTHOR", "AUTH_ATTEMPT_INFO", "BANDANA", "BRANCH_COMMIT_INFO", "BRS_ARTIFACT_LINK", "BRS_CONSUMED_SUBSCRIPTION", "BRS_LINKEDJIRAISSUES", "BUILD", "BUILDRESULTSUMMARY", "BUILDRESULTSUMMARY_CUSTOMDATA", "BUILDRESULTSUMMARY_LABEL", "BUILD_DEFINITION", "BUILD_NUMBERS", "CAPABILITY", "CAPABILITY_SET", "CHAIN_STAGE", "CHAIN_STAGE_RESULT", "COMMIT_FILES", "CREDENTIALS", "DEPLOYMENT_ENVIRONMENT", "DEPLOYMENT_ENV_VCS_LOCATION", "DEPLOYMENT_PROJECT", "DEPLOYMENT_PROJECT_ITEM", "DEPLOYMENT_PROJECT_ITEM_BA", "DEPLOYMENT_RESULT", "DEPLOYMENT_RESULT_CUSTOMDATA", "DEPLOYMENT_VARIABLE_SUBS", "DEPLOYMENT_VERSION", "DEPLOYMENT_VERSION_CHANGESET", "DEPLOYMENT_VERSION_COMMIT", "DEPLOYMENT_VERSION_ITEM", "DEPLOYMENT_VERSION_ITEM_BA", "DEPLOYMENT_VERSION_JIRA_ISSUE", "DEPLOYMENT_VERSION_NAMING", "DEPLOYMENT_VERSION_STATUS", "DEP_VERSION_PLANRESULTKEYS", "EC2_IMAGE_SCRIPT", "ELASTIC_IMAGE", "ELASTIC_SCHEDULE", "EXTERNAL_ENTITIES", "EXTERNAL_MEMBERS", "GROUPS", "ID_GENERATOR", "IMSERVER", "LABEL", "LOCAL_MEMBERS", "MERGE_RESULT", "NOTIFICATIONS", "NOTIFICATION_SETS", "ORPHANED_TESTS_CLEANUP_JOB", "OS_PROPERTYENTRY", "PASSWORD_RESET_TOKEN", "PLAN_DEPENDENCIES", "PLAN_VCS_HISTORY", "PLAN_VCS_LOCATION", "PROJECT", "QUEUE", "QUICK_FILTERS", "QUICK_FILTER_RULES", "RELEVANT_CHANGESETS", "REMEMBERME_TOKEN", "REPOSITORY_CHANGESET", "REQUIREMENT", "REQUIREMENT_SET", "SCRIPT", "STAGE_VARIABLE_CONTEXT", "TEST_CASE", "TEST_CASE_RESULT", "TEST_CLASS", "TEST_CLASS_RESULT", "TEST_ERROR", "TRUSTED_APPS", "TRUSTED_APPS_IPS", "TRUSTED_APPS_URLS", "TRUSTED_KEY", "USERS", "USER_COMMENT", "USER_COMMIT", "VARIABLESTOAUTOINCREMENT", "VARIABLE_BASELINE_ITEM", "VARIABLE_CONTEXT", "VARIABLE_CONTEXT_BASELINE", "VARIABLE_DEFINITION", "VARIABLE_SUBSTITUTION", "VCS_BRANCH", "VCS_LOCATION"};
    private static final Logger log = Logger.getLogger(AbstractMSSQLConvertColumnUpgradeTask.class);
    @Autowired
    private DbmsBean dbmsBean;

    public AbstractMSSQLConvertColumnUpgradeTask(@NotNull String shortDescription) {
        super(shortDescription);
    }

    protected abstract Predicate<DbmsBean.ColumnDefinition> getConversionConditionPredicate();

    protected abstract int getTargetSqlType();

    public void doUpgrade() throws Exception {
        if (!this.dbmsBean.isMsSqlServer()) {
            return;
        }
        this.withDatabaseConnection(c -> {
            List<String> presentTables = Arrays.stream(ALL_TABLES).filter(table -> (Boolean)BambooCallables.callUnchecked(() -> this.dbmsBean.isTablePresent(c, table))).collect(Collectors.toList());
            AtomicInteger successCounter = new AtomicInteger();
            AtomicInteger failureCounter = new AtomicInteger();
            this.convertTables(c, presentTables, this.getConversionConditionPredicate(), this.getTargetSqlType(), successCounter, failureCounter);
        });
    }

    public void convertTables(Connection c, Collection<String> tables, Predicate<DbmsBean.ColumnDefinition> predicate, int newType, AtomicInteger successCounter, AtomicInteger failureCounter) throws SQLException {
        Map<String, Collection<DbmsBean.ColumnDefinition>> columnsToConvert = this.getColumnsToConvert(c, tables, predicate);
        if (this.dbmsBean.isMsSqlServer() || this.dbmsBean.isHsqldb() || this.dbmsBean.isMySql()) {
            this.dropFkConstraints(c, columnsToConvert);
        }
        this.changeColumnTypes(c, columnsToConvert, newType, successCounter, failureCounter);
    }

    private Map<String, Collection<DbmsBean.ColumnDefinition>> getColumnsToConvert(Connection c, Collection<String> tables, Predicate<DbmsBean.ColumnDefinition> predicate) throws SQLException {
        HashMultimap tablesAndColumnsToConvert = HashMultimap.create();
        log.info((Object)"Retrieving columns to convert...");
        for (String table : tables) {
            List columns = this.dbmsBean.getColumns(c, table, null);
            columns.stream().filter(predicate).forEach(column -> tablesAndColumnsToConvert.put((Object)table, column));
        }
        return tablesAndColumnsToConvert.asMap();
    }

    private void dropFkConstraints(Connection c, Map<String, Collection<DbmsBean.ColumnDefinition>> allBigIntColumns) throws SQLException {
        log.info((Object)"Removing FK constraints...");
        for (Map.Entry<String, Collection<DbmsBean.ColumnDefinition>> bigIntColumnsInTable : allBigIntColumns.entrySet()) {
            String table = bigIntColumnsInTable.getKey();
            for (DbmsBean.ColumnDefinition column : bigIntColumnsInTable.getValue()) {
                for (DbmsBean.ConstraintDefinition constraint : this.dbmsBean.getConstraints(c, table, column.getName())) {
                    if (!constraint.isForeignKey()) continue;
                    this.dbmsBean.dropForeignKeyConstraint(c, table, constraint.getName());
                }
            }
        }
    }

    private void changeColumnTypes(Connection c, Map<String, Collection<DbmsBean.ColumnDefinition>> allBigIntColumns, int newType, AtomicInteger successCounter, AtomicInteger failureCounter) throws SQLException {
        for (Map.Entry<String, Collection<DbmsBean.ColumnDefinition>> bigIntColumnsInTable : allBigIntColumns.entrySet()) {
            String table = bigIntColumnsInTable.getKey();
            log.info((Object)("Converting columns in table " + table));
            for (DbmsBean.ColumnDefinition column : bigIntColumnsInTable.getValue()) {
                this.changeColumnType(c, table, column, newType, successCounter, failureCounter);
            }
        }
    }

    private void changeColumnType(Connection c, String table, DbmsBean.ColumnDefinition column, int newType, AtomicInteger successCounter, AtomicInteger failureCounter) throws SQLException {
        try {
            this.dbmsBean.changeColumnType(c, table, column.getName(), newType, null, column.isNullable().orElse(true).booleanValue());
            log.info((Object)("Succesfully converted column " + column));
            c.commit();
            successCounter.incrementAndGet();
        }
        catch (SQLException e) {
            failureCounter.incrementAndGet();
            log.info((Object)("Failed to convert column " + column), (Throwable)e);
            c.rollback();
        }
    }
}

