/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks;

import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.capability.ImageCapabilitySetHibernateDao;
import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.upgrade.tasks.AbstractInHibernateTransactionUpgradeTask;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.ImageCapabilitySet;
import io.atlassian.fugue.Pair;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.orm.hibernate5.HibernateCallback;

public abstract class AbstractElasticCapabilityUpgradeTask
extends AbstractInHibernateTransactionUpgradeTask {
    private static final Logger log = Logger.getLogger(AbstractElasticCapabilityUpgradeTask.class);
    private ImageCapabilitySetHibernateDao imageCapabilityDao;
    private BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate;

    public AbstractElasticCapabilityUpgradeTask(String taskNumber, String taskDescription) {
        super(taskNumber, taskDescription);
    }

    @Override
    public void doUpgrade(@NotNull Connection connection) throws SQLException {
        this.bambooTransactionHibernateTemplate.execute(new HibernateCallback(){

            @Nullable
            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("findImagesUsingShippedAmi").setParameter("trueValue", (Object)true);
                List imagesToUpdate = query.list();
                Map<Pair<String, String>, String> pathFixes = AbstractElasticCapabilityUpgradeTask.this.getPathFixes();
                for (ElasticImageConfiguration elasticImageConfiguration : imagesToUpdate) {
                    log.info((Object)("Checking image " + elasticImageConfiguration.getConfigurationName() + " to see if any update is required."));
                    ImageCapabilitySet capabilitySet = elasticImageConfiguration.getCapabilitySet();
                    AbstractElasticCapabilityUpgradeTask.this.modifyPathsWithMinorRevisions(pathFixes, capabilitySet);
                    AbstractElasticCapabilityUpgradeTask.this.imageCapabilityDao.saveCapabilitySet((CapabilitySet)capabilitySet);
                }
                return null;
            }
        });
    }

    protected abstract Map<Pair<String, String>, String> getPathFixes();

    protected void addFixingMapping(Map<Pair<String, String>, String> fixes, String fixedPath, String ... possibleValues) {
        for (int i = 0; i < possibleValues.length / 2; ++i) {
            String key = possibleValues[i * 2];
            String value = possibleValues[i * 2 + 1];
            fixes.put((Pair<String, String>)Pair.pair((Object)key, (Object)value), fixedPath);
        }
    }

    private void modifyPathsWithMinorRevisions(Map<Pair<String, String>, String> pathFixes, ImageCapabilitySet capabilitySet) {
        for (Capability capability : capabilitySet.getCapabilities()) {
            String capabilityKey;
            String fixedPath;
            String capabilityValue = capability.getValue();
            if (capabilityValue == null || (fixedPath = pathFixes.get(Pair.pair((Object)(capabilityKey = capability.getKey()), (Object)capabilityValue))) == null) continue;
            log.info((Object)("Modifying [" + capabilityKey + "]: " + capabilityValue + " -> " + fixedPath));
            capability.setValue(fixedPath);
        }
    }

    public void setImageCapabilityDao(ImageCapabilitySetHibernateDao imageCapabilityDao) {
        this.imageCapabilityDao = imageCapabilityDao;
    }

    public void setBambooTransactionHibernateTemplate(BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate) {
        this.bambooTransactionHibernateTemplate = bambooTransactionHibernateTemplate;
    }
}

