/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.onstartup;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.webhook.WebhookTemplateDao;
import com.atlassian.bamboo.webhook.WebhookTemplateEntity;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.springframework.http.HttpMethod;

public class PredefinedWebhookTemplateService {
    private static final Logger log = Logger.getLogger(PredefinedWebhookTemplateService.class);
    private static final String WEBHOOK_NAME_BUILD = "Build webhook";
    private static final String WEBHOOK_NAME_DEPLOY = "Deploy webhook";
    private static final String DEFAULT_WEBHOOKS_ALREADY_ADDED = "com.atlassian.bamboo.upgrade.tasks.repeatable.PredefinedWebhookTemplateService.DEFAULT_WEBHOOKS_ALREADY_ADDED";
    @Inject
    private WebhookTemplateDao webhookTemplateDao;
    @Inject
    private BandanaManager bandanaManager;

    public void addDefaultWebhookTemplates() throws Exception {
        if (Boolean.TRUE.equals(this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, DEFAULT_WEBHOOKS_ALREADY_ADDED))) {
            log.info((Object)"Default webhook templates have been already added");
            return;
        }
        if (!this.webhookTemplateDao.exists(WEBHOOK_NAME_BUILD)) {
            this.webhookTemplateDao.save((BambooObject)this.buildDefaultWebhook());
            log.info((Object)String.format("Default Webhook template '%s' has been saved", WEBHOOK_NAME_BUILD));
        } else {
            log.info((Object)String.format("Default Webhook template '%s' already exists", WEBHOOK_NAME_BUILD));
        }
        if (!this.webhookTemplateDao.exists(WEBHOOK_NAME_DEPLOY)) {
            this.webhookTemplateDao.save((BambooObject)this.deploymentDefaultWebhook());
            log.info((Object)String.format("Default Webhook template '%s' has been saved", WEBHOOK_NAME_DEPLOY));
        } else {
            log.info((Object)String.format("Default Webhook template '%s' already exists", WEBHOOK_NAME_DEPLOY));
        }
        this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, DEFAULT_WEBHOOKS_ALREADY_ADDED, (Object)Boolean.TRUE);
    }

    private WebhookTemplateEntity buildDefaultWebhook() {
        WebhookTemplateEntity webhookTemplateEntity = new WebhookTemplateEntity(HttpMethod.POST, "content-type:application/json", this.buildDefaultWebhookPayload(), WEBHOOK_NAME_BUILD);
        webhookTemplateEntity.setUuid(UUID.randomUUID());
        return webhookTemplateEntity;
    }

    private WebhookTemplateEntity deploymentDefaultWebhook() {
        WebhookTemplateEntity webhookTemplateEntity = new WebhookTemplateEntity(HttpMethod.POST, "content-type:application/json", this.deployDefaultWebhookPayload(), WEBHOOK_NAME_DEPLOY);
        webhookTemplateEntity.setUuid(UUID.randomUUID());
        return webhookTemplateEntity;
    }

    private String buildDefaultWebhookPayload() {
        String payload = "{\n  \"uuid\": \"${bamboo.webhook.uuid}\",\n  \"timestamp\": \"${bamboo.webhook.timestamp}\",\n  \"notification\": \"${bamboo.webhook.notification.description}\",\n  \"webhook\": {\n    \"webhookTemplatedId\": \"${bamboo.webhook.template.id}\",\n    \"webhookTemplatedName\": \"${bamboo.webhook.template.name}\"\n  },\n  \"build\": {\n    \"buildResultKey\": \"${bamboo.buildResultKey}\",\n    \"status\": \"${bamboo.buildState}\",\n    \"buildPlanName\": \"${bamboo.buildPlanName}\",\n    \"startedAt\": \"${bamboo.date.started}\",\n    \"finishedAt\": \"${bamboo.date.finished}\",\n    \"triggerReason\": \"${bamboo.trigger.reason}\",\n    \"triggerSentence\": \"${bamboo.trigger.name.for.sentence}\"\n  }\n}";
        return payload;
    }

    private String deployDefaultWebhookPayload() {
        String payload = "{\n  \"uuid\" : \"${bamboo.webhook.uuid}\",\n  \"timestamp\" : \"${bamboo.webhook.timestamp}\",\n  \"notification\" : \"${bamboo.webhook.notification.description}\",\n  \"webhook\" : {\n    \"webhookTemplatedId\" : \"${bamboo.webhook.template.id}\",\n    \"webhookTemplatedName\" : \"${bamboo.webhook.template.name}\"\n  },\n  \"deployment\" : {\n    \"deploymentResultId\" : \"${bamboo.deploy.result.id}\",\n    \"status\" : \"${bamboo.buildState}\",\n    \"deploymentProjectId\" : \"${bamboo.deploy.project.id}\",\n    \"environmentId\" : \"${bamboo.deploy.environment.id}\",\n    \"environmentName\": \"${bamboo.deploy.environment.name}\",\n    \"deploymentVersionId\" : \"${bamboo.deploy.version.id}\",\n    \"deploymentVersionName\" : \"${bamboo.deploy.version.name}\",\n\n    \"startedAt\" : \"${bamboo.date.started}\",\n    \"finishedAt\" : \"${bamboo.date.finished}\",\n    \"agentId\" : \"${bamboo.agentId}\",\n\n    \"triggerReason\" : \"${bamboo.trigger.reason}\",\n    \"triggerSentence\" : \"${bamboo.trigger.name.for.sentence}\"\n  }\n}";
        return payload;
    }
}

