/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade;

import com.atlassian.bamboo.configuration.ConfigurationException;
import com.atlassian.bamboo.container.BambooContainer;
import com.atlassian.bamboo.executor.SystemSecurityContextExecutors;
import com.atlassian.bamboo.hibernate.BambooSchemaHelper;
import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.upgrade.UpgradeManager;
import com.atlassian.bamboo.upgrade.onstartup.PredefinedWebhookTemplateService;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.web.utils.JohnsonEventContainerHolder;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.extras.api.bamboo.BambooLicense;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.config.XmlJohnsonConfig;
import com.atlassian.johnson.event.Event;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.concurrent.FutureTask;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

public class UpgradeLauncher
implements ServletContextListener {
    private static final Logger log = Logger.getLogger(UpgradeLauncher.class);

    public void contextInitialized(ServletContextEvent sce) {
        UpgradeLauncher.upgradeAndStartBamboo(sce.getServletContext(), false);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }

    public static synchronized void upgradeAndStartBamboo(ServletContext servletContext, boolean isPartOfSetup) {
        BootstrapManager bootstrapManager = (BootstrapManager)BootstrapUtils.getBootstrapManager();
        if (!bootstrapManager.isSetupComplete()) {
            log.info((Object)"Upgrades not performed since the application has not been set up yet.");
            return;
        }
        log.info((Object)("Starting " + UpgradeLauncher.class.getSimpleName()));
        JohnsonEventContainer agentJohnson = JohnsonEventContainerHolder.get((ServletContext)servletContext);
        XmlJohnsonConfig johnsonConfig = XmlJohnsonConfig.fromFile((String)"johnson-config.xml");
        try {
            BambooLicenseManager licenseManager = (BambooLicenseManager)BootstrapUtils.getBootstrapContext().getBean("bambooLicenseManager");
            BambooLicense license = licenseManager.getLicense();
            if (license != null && licenseManager.isMaintenanceExpiredForBuild()) {
                SimpleDateFormat sdf = new SimpleDateFormat("dd MMMM yyyy");
                log.fatal((Object)"Unable to upgrade Bamboo instance as your support period has ended");
                agentJohnson.addEvent(new Event(johnsonConfig.getEventType("license-too-old"), "Bamboo cannot be upgraded as your support period ended on " + sdf.format(license.getMaintenanceExpiryDate()) + ".", johnsonConfig.getEventLevel("fatal")));
                return;
            }
            if (!isPartOfSetup) {
                Dependencies dependencies = new Dependencies();
                SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)dependencies, (ServletContext)servletContext);
                log.info((Object)"Updating database schema...");
                dependencies.getSchemaHelper().updateSchemaIfNeeded(true);
            }
            Logger.getLogger((String)"org.hibernate").setLevel(Level.INFO);
            log.info((Object)"Initialising Bamboo container");
            BambooContainer bambooContainer = UpgradeLauncher.initialiseBambooContainer();
            servletContext.setAttribute("com.atlassian.bamboo.Bamboo", (Object)bambooContainer);
            UpgradeLauncher.addDefaultWebhooks();
            log.info((Object)"Initialisation completed.");
            UpgradeManager upgradeManager = (UpgradeManager)ContainerManager.getComponent((String)"upgradeManager");
            try {
                if (upgradeManager.needUpgrade()) {
                    log.info((Object)("Current data is at build number: " + upgradeManager.getBuildNumber() + ". Upgrade required. Firing upgrade manager..."));
                    Stopwatch stopWatch = Stopwatch.createStarted();
                    ListeningExecutorService executorService = SystemSecurityContextExecutors.newSingleThreadExecutor((String)"UpgradeTaskBackgroundThread");
                    FutureTask<List> upgrader = new FutureTask<List>(() -> upgradeManager.doUpgrade(isPartOfSetup));
                    executorService.submit(upgrader);
                    List errors = upgrader.get();
                    executorService.shutdown();
                    if (!errors.isEmpty()) {
                        for (String error : errors) {
                            log.fatal((Object)("Upgrade task error: " + error));
                            agentJohnson.addEvent(new Event(johnsonConfig.getEventType("bootstrap"), "Bamboo has encountered errors while upgrading. Please resolve these errors and restart Bamboo.", error, johnsonConfig.getEventLevel("fatal")));
                        }
                        return;
                    }
                    log.info((Object)("Upgrade completed. " + stopWatch));
                }
            }
            catch (Exception e) {
                log.fatal((Object)"Failed to upgrade Bamboo", (Throwable)e);
                agentJohnson.addEvent(new Event(johnsonConfig.getEventType("bootstrap"), "Bamboo has encountered errors while upgrading. Please resolve these errors and restart Bamboo.", e.getMessage(), johnsonConfig.getEventLevel("fatal")));
                return;
            }
            bambooContainer.start(servletContext);
        }
        catch (Exception e) {
            log.fatal((Object)"Failed to initialise Bamboo container", (Throwable)e);
            agentJohnson.addEvent(new Event(johnsonConfig.getEventType("bootstrap"), "Error while trying to initialise Bamboo Container. " + e.getMessage(), johnsonConfig.getEventLevel("fatal")));
            throw new RuntimeException("Failed to upgrade", e);
        }
    }

    private static void addDefaultWebhooks() {
        try {
            PredefinedWebhookTemplateService predefinedWebhookTemplateService = new PredefinedWebhookTemplateService();
            ContainerManager.autowireComponent((Object)predefinedWebhookTemplateService);
            predefinedWebhookTemplateService.addDefaultWebhookTemplates();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
        }
    }

    public static synchronized void initialisePlansAfterImport(ServletContext servletContext) throws IOException {
        BambooContainer bambooContainer = (BambooContainer)Narrow.to((Object)servletContext.getAttribute("com.atlassian.bamboo.Bamboo"), BambooContainer.class);
        if (bambooContainer != null) {
            bambooContainer.initialisePlansAfterImport();
        } else {
            log.warn((Object)"BambooContainer not available in servlet context");
        }
    }

    private static BambooContainer initialiseBambooContainer() throws ConfigurationException {
        try {
            BambooContainer bambooContainer = new BambooContainer();
            ContainerManager.autowireComponent((Object)bambooContainer);
            bambooContainer.initialise();
            return bambooContainer;
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to start Bamboo", (Throwable)e);
        }
    }

    private static class Dependencies {
        @Autowired
        private BambooSchemaHelper schemaHelper;

        private Dependencies() {
        }

        public BambooSchemaHelper getSchemaHelper() {
            return this.schemaHelper;
        }
    }
}

