/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.struts;

import com.atlassian.bamboo.struts.JsonStream;
import com.atlassian.bamboo.struts.JsonStreamingAction;
import com.atlassian.bamboo.util.Narrow;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.Result;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.entity.ContentType;
import org.apache.log4j.Logger;

public class JsonStreamResult
implements Result {
    private static final Logger log = Logger.getLogger(JsonStreamResult.class);

    public void execute(ActionInvocation invocation) throws Exception {
        JsonStreamingAction action;
        if (log.isDebugEnabled()) {
            log.debug((Object)("executing " + this.getClass()));
        }
        if ((action = JsonStreamResult.getJsonStreamingAction(invocation)) == null) {
            return;
        }
        HttpServletResponse response = JsonStreamResult.getServletResponse(invocation);
        response.setContentType(ContentType.APPLICATION_JSON.toString());
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        PrintWriter writer = response.getWriter();
        try (JsonStream jsonStream = new JsonStream(writer);){
            action.streamJson(jsonStream);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        writer.flush();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.getClass() + " finished"));
        }
    }

    private static JsonStreamingAction getJsonStreamingAction(ActionInvocation invocation) {
        Object someAction = invocation.getAction();
        JsonStreamingAction action = (JsonStreamingAction)Narrow.downTo((Object)someAction, JsonStreamingAction.class);
        if (action == null) {
            log.error((Object)("Action " + someAction.getClass() + " is not " + JsonStreamingAction.class));
        }
        return action;
    }

    private static HttpServletResponse getServletResponse(ActionInvocation invocation) {
        return (HttpServletResponse)invocation.getInvocationContext().getContextMap().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
    }
}

