/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.struts;

import com.atlassian.bamboo.util.Narrow;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Preconditions;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonStream
implements AutoCloseable {
    private final JsonGenerator generator;

    public JsonStream(Writer writer) throws IOException {
        JsonFactory factory = new JsonFactory();
        this.generator = factory.createGenerator(writer);
        this.generator.writeStartObject();
    }

    public void writeArrayFieldStart(String fieldName) throws IOException {
        this.generator.writeArrayFieldStart(fieldName);
    }

    public void writeStartObject() throws IOException {
        this.generator.writeStartObject();
    }

    public void writeEndObject() throws IOException {
        this.generator.writeEndObject();
    }

    public void writeEndArray() throws IOException {
        this.generator.writeEndArray();
    }

    public JsonStream put(String key, boolean value) throws IOException {
        this.generator.writeBooleanField(key, value);
        return this;
    }

    public JsonStream put(String key, int value) throws IOException {
        this.generator.writeNumberField(key, value);
        return this;
    }

    public JsonStream put(String key, long value) throws IOException {
        this.generator.writeNumberField(key, value);
        return this;
    }

    public JsonStream put(String key, float value) throws IOException {
        this.generator.writeNumberField(key, value);
        return this;
    }

    public JsonStream put(String key, double value) throws IOException {
        this.generator.writeNumberField(key, value);
        return this;
    }

    public JsonStream putIfNotNull(@NotNull String key, @Nullable Object value) throws IOException {
        if (value != null) {
            this.put(key, value);
        }
        return this;
    }

    public JsonStream put(@NotNull String key, @NotNull Object value) throws IOException {
        Preconditions.checkNotNull((Object)key, (Object)"Null key.");
        Preconditions.checkNotNull((Object)value, (Object)("Entry removal semantics not supported (on " + key + ")."));
        JsonStream.testValidity(value);
        Number number = (Number)Narrow.downTo((Object)value, Number.class);
        if (value instanceof Number) {
            this.writeNumber(key, number);
        } else if (value instanceof Boolean) {
            this.generator.writeBooleanField(key, ((Boolean)value).booleanValue());
        } else {
            this.generator.writeStringField(key, value.toString());
        }
        return this;
    }

    private void writeNumber(String key, Number value) throws IOException {
        if (value instanceof Integer) {
            this.put(key, value.intValue());
        } else if (value instanceof Long) {
            this.put(key, value.longValue());
        } else if (value instanceof Float) {
            this.put(key, value.floatValue());
        } else if (value instanceof Double) {
            this.put(key, value.doubleValue());
        } else {
            throw new IllegalArgumentException("Unknown number type " + value.getClass());
        }
    }

    public JsonStream put(String key, JSONObject value) throws IOException {
        Preconditions.checkNotNull((Object)key, (Object)"Null key.");
        Preconditions.checkNotNull((Object)value, (Object)"Entry removal semantics not supported.");
        this.generator.writeFieldName(key);
        this.generator.writeRawValue(value.toString());
        return this;
    }

    public JsonStream put(String key, Collection<?> value) throws IOException {
        this.generator.writeArrayFieldStart(key);
        for (Object o : value) {
            if (o instanceof JSONObject || o instanceof Number) {
                this.generator.writeRawValue(o.toString());
                continue;
            }
            this.generator.writeString(o.toString());
        }
        this.generator.writeEndArray();
        return this;
    }

    public JsonStream put(String key, Map value) throws IOException {
        this.generator.writeObjectFieldStart(key);
        Map map = value;
        for (Map.Entry entry : map.entrySet()) {
            this.put((String)entry.getKey(), entry.getValue());
        }
        this.generator.writeEndObject();
        return this;
    }

    private static void testValidity(Object o) {
        if (o instanceof Double) {
            Double val = (Double)o;
            Preconditions.checkArgument((!val.isInfinite() && !val.isNaN() ? 1 : 0) != 0, (Object)"JSON does not allow non-finite numbers.");
        } else if (o instanceof Float) {
            Float val = (Float)o;
            Preconditions.checkArgument((!val.isInfinite() && !val.isNaN() ? 1 : 0) != 0, (Object)"JSON does not allow non-finite numbers.");
        }
    }

    @Override
    public void close() throws Exception {
        this.generator.close();
    }
}

