/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.spring;

import com.atlassian.bamboo.spring.EventuallyAutowired;
import com.atlassian.bamboo.spring.SpringProxy;
import com.atlassian.bamboo.utils.BambooReflectionUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.InvocationHandler;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;
import org.springframework.web.context.support.WebApplicationContextUtils;

public final class EventuallyAutowiredSupport {
    private EventuallyAutowiredSupport() {
    }

    private static Object eventuallyAutowiredProxy(Object targetObject, ServletContext servletContext) {
        AtomicBoolean hasWiringBeenAttempted = new AtomicBoolean();
        InvocationHandler invocationHandler = (o, method, objects) -> {
            if (!EventuallyAutowiredSupport.isWebAppContextReady(servletContext)) {
                return null;
            }
            Object object = o;
            synchronized (object) {
                if (hasWiringBeenAttempted.compareAndSet(false, true)) {
                    SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)targetObject, (ServletContext)servletContext);
                }
            }
            method.setAccessible(true);
            return method.invoke(targetObject, objects);
        };
        return SpringProxy.newProxyInstance(targetObject.getClass(), (Callback)invocationHandler);
    }

    public static void processInjectionBasedOnServletContext(Object parentBean, ServletContext servletContext) {
        boolean runInjectionOnParentBean = false;
        for (Field fieldOfParent : BambooReflectionUtils.getAllDeclaredFields(parentBean.getClass())) {
            Object proxyOrObject;
            runInjectionOnParentBean |= fieldOfParent.isAnnotationPresent(Autowired.class) || fieldOfParent.isAnnotationPresent(Inject.class);
            if (!fieldOfParent.isAnnotationPresent(EventuallyAutowired.class)) continue;
            Object targetBean = SpringProxy.newInstance(fieldOfParent.getType());
            if (EventuallyAutowiredSupport.isWebAppContextReady(servletContext)) {
                SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)targetBean, (ServletContext)servletContext);
                proxyOrObject = targetBean;
            } else {
                proxyOrObject = EventuallyAutowiredSupport.eventuallyAutowiredProxy(targetBean, servletContext);
            }
            EventuallyAutowiredSupport.setField(parentBean, fieldOfParent, proxyOrObject);
        }
        if (runInjectionOnParentBean) {
            SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)parentBean, (ServletContext)servletContext);
        }
    }

    private static void setField(Object target, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @VisibleForTesting
    static boolean isWebAppContextReady(ServletContext servletContext) {
        return WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext) != null;
    }
}

