/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.soy;

import com.atlassian.bamboo.jsonator.Jsonator;
import com.atlassian.bamboo.soy.SoyHelperFunctions;
import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Set;
import org.apache.log4j.Logger;

public class ToJsonSoyFunction
implements SoyServerFunction<String>,
SoyClientFunction {
    private static final Logger log = Logger.getLogger(ToJsonSoyFunction.class);
    private final Jsonator jsonator;

    public ToJsonSoyFunction(Jsonator jsonator) {
        this.jsonator = jsonator;
    }

    public String getName() {
        return "to_json";
    }

    public String apply(Object ... args) {
        return this.jsonator.convert(args[0]).toString();
    }

    public Set<Integer> validArgSizes() {
        return ImmutableSet.of((Object)1);
    }

    public JsExpression generate(JsExpression ... jsExpressions) {
        StringBuilder sb = new StringBuilder("console.log(");
        Joiner.on((String)", ").appendTo(sb, Iterables.transform(Arrays.asList(jsExpressions), SoyHelperFunctions.jsExpressionGetText()));
        sb.append(")");
        return new JsExpression(sb.toString());
    }
}

