/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.soy;

import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import org.acegisecurity.acls.Permission;

public class HasGlobalPermissionSoyFunction
implements SoyServerFunction<Boolean>,
SoyClientFunction {
    @Inject
    private BambooPermissionManager bambooPermissionManager;

    public String getName() {
        return "has_global_permission";
    }

    public Boolean apply(Object ... args) {
        Object argument = args[0];
        String permissionString = (String)Narrow.downTo((Object)argument, String.class);
        Preconditions.checkArgument((permissionString != null ? 1 : 0) != 0);
        Permission permission = BambooPermission.buildFromName((String)permissionString);
        return this.bambooPermissionManager.hasGlobalPermission(permission);
    }

    public JsExpression generate(JsExpression ... args) {
        return new JsExpression("true");
    }

    public Set<Integer> validArgSizes() {
        return Collections.singleton(1);
    }

    @Deprecated
    public void setBambooPermissionManager(BambooPermissionManager bambooPermissionManager) {
        this.bambooPermissionManager = bambooPermissionManager;
    }
}

