/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.soy;

import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.opensymphony.xwork2.TextProvider;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;

public class FormatDateSoyFunction
implements SoyServerFunction<String>,
SoyClientFunction {
    private static final Logger log = Logger.getLogger(FormatDateSoyFunction.class);
    private static final Set<Integer> VALID_ARG_SIZES = Sets.newHashSet((Object[])new Integer[]{1, 2});
    private static final DATE_FORMAT DEFAULT_FORMAT = DATE_FORMAT.SHORT;
    private final TextProvider textProvider;

    public FormatDateSoyFunction(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    public String getName() {
        return "format_date";
    }

    public String apply(Object ... args) {
        DATE_FORMAT date_format;
        Object dateArg = args[0];
        Preconditions.checkArgument((dateArg instanceof Date || dateArg instanceof Number ? 1 : 0) != 0);
        Date date = dateArg instanceof Date ? (Date)dateArg : new Date(((Number)dateArg).longValue());
        DateTime dateTime = new DateTime((Object)date);
        if (args.length == 2) {
            Object formattingArg = args[1];
            Preconditions.checkArgument((boolean)(formattingArg instanceof String));
            date_format = DATE_FORMAT.fromString((String)formattingArg);
        } else {
            date_format = DEFAULT_FORMAT;
        }
        return this.formatDate(dateTime, date_format);
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZES;
    }

    public JsExpression generate(JsExpression ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append("BAMBOO.Time.format(");
        String sep = "";
        for (JsExpression expr : args) {
            sb.append(sep).append(expr.getText());
            sep = ", ";
        }
        if (args.length < 2) {
            sb.append(sep).append("'" + DEFAULT_FORMAT.name().toLowerCase() + "'");
        }
        sb.append(")");
        return new JsExpression(sb.toString());
    }

    String formatDate(DateTime date, DATE_FORMAT type) {
        if (type.isAge()) {
            return this.formatDateWithRelativeAge(date, type.getKey());
        }
        return this.formatDateWithFormatString(date, type.getKey());
    }

    String getFormatString(String key) {
        return this.textProvider.getText(key);
    }

    String formatDateWithFormatString(DateTime dateTime, String key) {
        return dateTime.toString(DateTimeFormat.forPattern((String)this.getFormatString(key)));
    }

    String formatDateWithRelativeAge(DateTime dateTime, String key) {
        return this.formatDateWithRelativeAge(new DateTime((Object)new Date()), dateTime, key);
    }

    String formatDateWithRelativeAge(DateTime now, DateTime date, String key) {
        if (!date.isAfter((ReadableInstant)now)) {
            if (date.isAfter((ReadableInstant)now.minus((ReadablePeriod)Period.minutes((int)1)))) {
                return this.textProvider.getText(key + ".a.moment.ago");
            }
            if (date.isAfter((ReadableInstant)now.minus((ReadablePeriod)Period.minutes((int)2)))) {
                return this.textProvider.getText(key + ".one.minute.ago");
            }
            if (date.isAfter((ReadableInstant)now.minus((ReadablePeriod)Period.minutes((int)50)))) {
                return this.textProvider.getText(key + ".x.minutes.ago", new String[]{Integer.toString(this.getMinutesBetween(date, now))});
            }
            if (date.isAfter((ReadableInstant)now.minus((ReadablePeriod)Period.minutes((int)90)))) {
                return this.textProvider.getText(key + ".one.hour.ago");
            }
            if (this.isYesterday(now, date) && date.isBefore((ReadableInstant)now.minus((ReadablePeriod)Period.hours((int)5)))) {
                return this.textProvider.getText(key + ".one.day.ago");
            }
            if (date.isAfter((ReadableInstant)now.minus((ReadablePeriod)Period.days((int)1)))) {
                return this.textProvider.getText(key + ".x.hours.ago", new String[]{Integer.toString(this.getHoursBetween(date, now))});
            }
            if (date.isAfter((ReadableInstant)now.minus((ReadablePeriod)Period.days((int)7)))) {
                return this.textProvider.getText(key + ".x.days.ago", new String[]{Integer.toString(Math.max(this.getDaysBetween(date, now), 2))});
            }
            if (date.isAfter((ReadableInstant)now.minus((ReadablePeriod)Period.days((int)8)))) {
                return this.textProvider.getText(key + ".one.week.ago");
            }
        }
        return this.formatDateWithFormatString(date, key);
    }

    private boolean isYesterday(DateTime now, DateTime date) {
        DateTime end = now.withTime(0, 0, 0, 0);
        DateTime start = end.minusDays(1);
        Interval interval = new Interval((ReadableInstant)start, (ReadableInstant)end);
        return interval.contains((ReadableInstant)date);
    }

    private int getMinutesBetween(DateTime start, DateTime end) {
        return new Period((ReadableInstant)start, (ReadableInstant)end).getMinutes();
    }

    private int getHoursBetween(DateTime start, DateTime end) {
        Period period = new Period((ReadableInstant)start, (ReadableInstant)end);
        int hours = period.getHours();
        if (period.getMinutes() >= 30) {
            ++hours;
        }
        return hours;
    }

    private int getDaysBetween(DateTime start, DateTime end) {
        return new Period((ReadableInstant)start, (ReadableInstant)end).getDays();
    }

    public static enum DATE_FORMAT {
        SHORT("bamboo.date.format.short"),
        LONG("bamboo.date.format.long"),
        FULL("bamboo.date.format.full"),
        DATETIME("bamboo.date.format.datetime"),
        TIMESTAMP("bamboo.date.format.timestamp"),
        SHORTAGE(SHORT),
        LONGAGE(LONG);

        private final String key;
        private final boolean age;

        private DATE_FORMAT(String key) {
            this.key = key;
            this.age = false;
        }

        private DATE_FORMAT(DATE_FORMAT delegate) {
            this.key = delegate.key;
            this.age = true;
        }

        public boolean isAge() {
            return this.age;
        }

        public String getKey() {
            return this.key;
        }

        public static DATE_FORMAT fromString(String s) {
            return DATE_FORMAT.valueOf(s != null ? s.toUpperCase() : null);
        }
    }
}

