/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.soy;

import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.opensymphony.xwork2.TextProvider;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;

public class ElapsedTimeSoyFunction
implements SoyServerFunction<String>,
SoyClientFunction {
    private static final Logger log = Logger.getLogger(ElapsedTimeSoyFunction.class);
    private TextProvider textProvider;

    public ElapsedTimeSoyFunction(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    public String getName() {
        return "elapsed_time";
    }

    public String apply(Object ... args) {
        Date to;
        Preconditions.checkArgument((boolean)(args[0] instanceof Date));
        Date from = (Date)args[0];
        if (args.length == 2) {
            Preconditions.checkArgument((boolean)(args[1] instanceof Date));
            to = (Date)args[1];
        } else {
            to = new Date();
        }
        return this.elapsedTime(new DateTime((Object)from), new DateTime((Object)to));
    }

    public Set<Integer> validArgSizes() {
        return Sets.newHashSet((Object[])new Integer[]{1, 2});
    }

    public JsExpression generate(JsExpression ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append("BAMBOO.Time.elapsedTime(");
        String sep = "";
        for (JsExpression expr : args) {
            sb.append(sep).append(expr.getText());
            sep = ", ";
        }
        sb.append(")");
        return new JsExpression(sb.toString());
    }

    private String elapsedTime(@NotNull DateTime dateFrom, @NotNull DateTime dateTo) {
        if (dateTo.isAfter((ReadableInstant)dateFrom) || dateTo.equals((Object)dateFrom)) {
            int months = this.getMonthsBetween(dateFrom, dateTo);
            if (months < 1) {
                int minutes = this.getMinutesBetween(dateFrom, dateTo);
                if (minutes < 1) {
                    int seconds = this.getSecondsBetween(dateFrom, dateTo);
                    if (seconds < 1) {
                        return this.textProvider.getText("bamboo.date.format.duration.long.a.moment.ago");
                    }
                    if (seconds > 1) {
                        return this.textProvider.getText("bamboo.date.format.duration.long.x.seconds", (List)Lists.newArrayList((Object[])new Integer[]{seconds}));
                    }
                    return this.textProvider.getText("bamboo.date.format.duration.long.one.second");
                }
                if (minutes > 1) {
                    return this.textProvider.getText("bamboo.date.format.duration.long.x.minutes", (List)Lists.newArrayList((Object[])new Integer[]{minutes}));
                }
                return this.textProvider.getText("bamboo.date.format.duration.long.one.minute");
            }
            return this.textProvider.getText("bamboo.date.format.duration.long.toolong");
        }
        log.warn((Object)String.format("Incorrect parameters passes to 'elapsed_time' [%d,%d]", dateFrom.getMillis(), dateTo.getMillis()));
        return null;
    }

    private int getMinutesBetween(DateTime start, DateTime end) {
        Period period = new Period((ReadableInstant)start, (ReadableInstant)end);
        return period.toStandardMinutes().getMinutes();
    }

    private int getMonthsBetween(DateTime start, DateTime end) {
        Period period = new Period((ReadableInstant)start, (ReadableInstant)end);
        return period.getMonths();
    }

    private int getSecondsBetween(DateTime start, DateTime end) {
        Period period = new Period((ReadableInstant)start, (ReadableInstant)end);
        return period.toStandardSeconds().getSeconds();
    }
}

